/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.responsibility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.common.template.TemplateContract;
import org.kuali.rice.kim.api.responsibility.ResponsibilityContract;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityAttributeBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityTemplateBo;
import org.kuali.rice.kim.impl.responsibility.ReviewResponsibilityBo;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class ReviewResponsibilityMaintainable
extends KualiMaintainableImpl {
    private static final Logger LOG = LogManager.getLogger(ReviewResponsibilityMaintainable.class);
    private static final long serialVersionUID = -8102504656976243468L;
    protected static final String DOCUMENT_TYPE_NAME = "documentTypeName";
    protected static final String ROUTE_NODE_NAME = "routeNodeName";
    private static Template REVIEW_TEMPLATE;

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (document.isEdit()) {
            for (Section section : sections) {
                for (Row row : section.getRows()) {
                    for (Field field : row.getFields()) {
                        if (!"actionDetailsAtRoleMemberLevel".equals(field.getPropertyName())) continue;
                        field.setReadOnly(true);
                    }
                }
            }
        }
        return sections;
    }

    public void saveDataObject() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Attempting to save ReviewResponsibilityBo BO via ResponsibilityService:" + this.getBusinessObject());
        }
        ReviewResponsibilityMaintainable.populateReviewTemplateInfo();
        ReviewResponsibilityBo resp = (ReviewResponsibilityBo)((Object)this.getDataObject());
        HashMap<String, String> details = new HashMap<String, String>();
        details.put(DOCUMENT_TYPE_NAME, resp.getDocumentTypeName());
        details.put(ROUTE_NODE_NAME, resp.getRouteNodeName());
        details.put("required", resp.isRequired() ? "true" : "false");
        details.put("actionDetailsAtRoleMemberLevel", resp.isActionDetailsAtRoleMemberLevel() ? "true" : "false");
        if (StringUtils.isNotBlank((String)resp.getQualifierResolverProvidedIdentifier())) {
            details.put("qualifierResolverProvidedIdentifier", resp.getQualifierResolverProvidedIdentifier());
        }
        if (resp.getTemplateId() == null) {
            resp.setTemplateId(REVIEW_TEMPLATE.getId());
            resp.setTemplate(ResponsibilityTemplateBo.from((TemplateContract)REVIEW_TEMPLATE));
        } else {
            resp.setTemplate(ResponsibilityTemplateBo.from((TemplateContract)KimApiServiceLocator.getResponsibilityService().getResponsibilityTemplate(resp.getTemplateId())));
        }
        resp.setAttributes(details);
        resp.setAttributeDetails(KimAttributeDataBo.createFrom(ResponsibilityAttributeBo.class, details, resp.getTemplate().getKimTypeId()));
        boolean responsibilityExists = false;
        if (resp.getId() != null) {
            boolean bl = responsibilityExists = KimApiServiceLocator.getResponsibilityService().getResponsibility(resp.getId()) != null;
        }
        if (responsibilityExists) {
            KimApiServiceLocator.getResponsibilityService().updateResponsibility(ResponsibilityBo.to(resp));
        } else {
            if (this.getMaintenanceAction().equals("Copy")) {
                if (StringUtils.isNotBlank((String)resp.getObjectId())) {
                    resp.setObjectId("");
                }
                if (null != resp.getVersionNumber()) {
                    resp.setVersionNumber(null);
                }
            }
            KimApiServiceLocator.getResponsibilityService().createResponsibility(ResponsibilityBo.to(resp));
        }
    }

    private static synchronized void populateReviewTemplateInfo() {
        if (REVIEW_TEMPLATE == null) {
            REVIEW_TEMPLATE = KimApiServiceLocator.getResponsibilityService().findRespTemplateByNamespaceCodeAndName("KR-WKFLW", "Review");
        }
    }

    public Class<? extends BusinessObject> getBoClass() {
        return ReviewResponsibilityBo.class;
    }

    public Class<?> getDataObjectClass() {
        return ReviewResponsibilityBo.class;
    }

    public void prepareBusinessObject(BusinessObject businessObject) {
        if (businessObject == null) {
            throw new RuntimeException("Configuration ERROR: ReviewResponsibilityBoMaintainable.prepareBusinessObject passed a null object.");
        }
        if (!(businessObject instanceof ResponsibilityContract)) {
            throw new RuntimeException("Configuration ERROR: ReviewResponsibilityBoMaintainable passed an unsupported object type: " + businessObject.getClass());
        }
        ResponsibilityBo resp = (ResponsibilityBo)((Object)KradDataServiceLocator.getDataObjectService().find(ResponsibilityBo.class, (Object)((ResponsibilityContract)businessObject).getId()));
        businessObject = new ReviewResponsibilityBo(resp);
        this.setDataObject(businessObject);
        super.prepareBusinessObject(businessObject);
    }

    public boolean isExternalBusinessObject() {
        return true;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        this.initializeResponsibilityId(document.getDocumentBusinessObject());
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.initializeResponsibilityId(document.getNewMaintainableObject().getDataObject());
    }

    private void initializeResponsibilityId(Object dataObject) {
        ReviewResponsibilityBo responsibilityBo;
        if (dataObject instanceof ReviewResponsibilityBo && StringUtils.isBlank((String)(responsibilityBo = (ReviewResponsibilityBo)((Object)dataObject)).getId())) {
            DataFieldMaxValueIncrementer incrementer = MaxValueIncrementerFactory.getIncrementer((DataSource)KimImplServiceLocator.getDataSource(), (String)"KRIM_RSP_ID_S");
            responsibilityBo.setId(incrementer.nextStringValue());
        }
    }

    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
        String docTypeName = "";
        String routeNodeName = "";
        ReviewResponsibilityBo reviewResponsibilityBo = (ReviewResponsibilityBo)((Object)document.getNewMaintainableObject().getDataObject());
        this.initializeResponsibilityId(document.getDocumentBusinessObject());
        reviewResponsibilityBo.setActive(true);
        for (String paramName : parameters.keySet()) {
            String[] parameterValues = parameters.get(paramName);
            if (paramName.equals(DOCUMENT_TYPE_NAME) && parameterValues.length > 0) {
                docTypeName = parameterValues[0];
            }
            if (!paramName.equals(ROUTE_NODE_NAME) || parameterValues.length <= 0) continue;
            routeNodeName = parameterValues[0];
        }
        if (StringUtils.isNotEmpty((String)docTypeName) && StringUtils.isNotEmpty((String)routeNodeName)) {
            reviewResponsibilityBo.setDocumentTypeName(docTypeName);
            reviewResponsibilityBo.setRouteNodeName(routeNodeName);
        }
        document.getNewMaintainableObject().setDataObject((Object)reviewResponsibilityBo);
    }
}

