/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.membership.AbstractMemberBo;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_ROLE_MBR_T")
public class RoleMemberBo
extends AbstractMemberBo
implements RoleMemberContract,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_ROLE_MBR_ID_S")
    @GeneratedValue(generator="KRIM_ROLE_MBR_ID_S")
    @Id
    @Column(name="ROLE_MBR_ID")
    private String id;
    @Column(name="ROLE_ID")
    private String roleId;
    @OneToMany(targetEntity=RoleMemberAttributeDataBo.class, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="ROLE_MBR_ID", referencedColumnName="ROLE_MBR_ID")
    private List<RoleMemberAttributeDataBo> attributeDetails;
    @Transient
    private List<RoleResponsibilityActionBo> roleRspActions;
    @Transient
    private Map<String, String> attributes;
    @Transient
    protected String memberName;
    @Transient
    protected String memberNamespaceCode;

    public List<RoleMemberAttributeDataBo> getAttributeDetails() {
        if (this._persistence_get_attributeDetails() == null) {
            return new AutoPopulatingList(RoleMemberAttributeDataBo.class);
        }
        return this._persistence_get_attributeDetails();
    }

    public void setAttributeDetails(List<RoleMemberAttributeDataBo> attributeDetails) {
        this._persistence_set_attributeDetails(attributeDetails);
    }

    public Map<String, String> getAttributes() {
        return this._persistence_get_attributeDetails() != null ? KimAttributeDataBo.toAttributes(this._persistence_get_attributeDetails()) : this.attributes;
    }

    public static RoleMember to(RoleMemberBo bo) {
        if (bo == null) {
            return null;
        }
        return RoleMember.Builder.create((RoleMemberContract)bo).build();
    }

    public static RoleMemberBo from(RoleMember immutable) {
        if (immutable == null) {
            return null;
        }
        RoleMemberBo bo = new RoleMemberBo();
        bo.memberName = immutable.getMemberName();
        bo.memberNamespaceCode = immutable.getMemberNamespaceCode();
        bo.setId(immutable.getId());
        bo.setRoleId(immutable.getRoleId());
        ArrayList<RoleResponsibilityActionBo> actions = new ArrayList<RoleResponsibilityActionBo>();
        if (CollectionUtils.isNotEmpty((Collection)immutable.getRoleRspActions())) {
            for (RoleResponsibilityAction roleRespActn : immutable.getRoleRspActions()) {
                actions.add(RoleResponsibilityActionBo.from(roleRespActn));
            }
        }
        bo.setRoleRspActions(actions);
        bo.setMemberId(immutable.getMemberId());
        bo.setTypeCode(immutable.getType().getCode());
        bo.setActiveFromDateValue(immutable.getActiveFromDate() == null ? null : new Timestamp(immutable.getActiveFromDate().getMillis()));
        bo.setActiveToDateValue(immutable.getActiveToDate() == null ? null : new Timestamp(immutable.getActiveToDate().getMillis()));
        bo.setObjectId(immutable.getObjectId());
        bo.setVersionNumber(immutable.getVersionNumber());
        return bo;
    }

    protected Object getMember(MemberType memberType, String memberId) {
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            return KimApiServiceLocator.getIdentityService().getPrincipal(memberId);
        }
        if (MemberType.GROUP.equals((Object)memberType)) {
            return KimApiServiceLocator.getGroupService().getGroup(memberId);
        }
        if (MemberType.ROLE.equals((Object)memberType)) {
            return KimApiServiceLocator.getRoleService().getRole(memberId);
        }
        return null;
    }

    public String getMemberName() {
        if (this.getType() == null || StringUtils.isEmpty((String)this.getMemberId())) {
            return "";
        }
        Object member = this.getMember(this.getType(), this.getMemberId());
        if (member == null) {
            this.memberName = "";
            Principal kp = KimApiServiceLocator.getIdentityService().getPrincipal(this.getMemberId());
            if (kp != null && kp.getPrincipalName() != null && !"".equals(kp.getPrincipalName())) {
                this.memberName = kp.getPrincipalName();
            }
            return this.memberName;
        }
        return this.getRoleMemberName(this.getType(), member);
    }

    public String getRoleMemberName(MemberType memberType, Object member) {
        String roleMemberName = "";
        if (MemberType.PRINCIPAL.equals((Object)memberType)) {
            roleMemberName = ((PrincipalContract)member).getPrincipalName();
        } else if (MemberType.GROUP.equals((Object)memberType)) {
            roleMemberName = ((GroupContract)member).getName();
        } else if (MemberType.ROLE.equals((Object)memberType)) {
            roleMemberName = ((RoleContract)member).getName();
        }
        return roleMemberName;
    }

    public String getMemberNamespaceCode() {
        Role role;
        if (this.getType() == null || StringUtils.isEmpty((String)this.getMemberId())) {
            return "";
        }
        this.memberNamespaceCode = "";
        if (MemberType.PRINCIPAL.equals((Object)this.getType())) {
            this.memberNamespaceCode = "";
        } else if (MemberType.GROUP.equals((Object)this.getType())) {
            Group groupInfo = KimApiServiceLocator.getGroupService().getGroup(this.getMemberId());
            if (groupInfo != null) {
                this.memberNamespaceCode = groupInfo.getNamespaceCode();
            }
        } else if (MemberType.ROLE.equals((Object)this.getType()) && (role = KimApiServiceLocator.getRoleService().getRole(this.getMemberId())) != null) {
            this.memberNamespaceCode = role.getNamespaceCode();
        }
        return this.memberNamespaceCode;
    }

    public boolean equals(RoleMemberBo targetMbrBo) {
        int n;
        if (!StringUtils.equals((String)this.getId(), (String)targetMbrBo.getId())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getType().getCode(), (String)targetMbrBo.getType().getCode())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getMemberId(), (String)targetMbrBo.getMemberId())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getActiveFromDate(), (Object)targetMbrBo.getActiveFromDate())) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.getActiveToDate(), (Object)targetMbrBo.getActiveToDate())) {
            return false;
        }
        HashMap<String, String> sourceMbrAttrDataList = new HashMap<String, String>();
        for (Map.Entry<String, String> mbrAttr : this.getAttributes().entrySet()) {
            if (!StringUtils.isNotBlank((String)mbrAttr.getValue())) continue;
            sourceMbrAttrDataList.put((String)mbrAttr.getKey(), (String)mbrAttr.getValue());
        }
        HashMap<String, String> targetMbrAttrDataList = new HashMap<String, String>();
        for (Map.Entry entry : targetMbrBo.getAttributes().entrySet()) {
            if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
            targetMbrAttrDataList.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (targetMbrAttrDataList.size() != sourceMbrAttrDataList.size()) {
            return false;
        }
        HashMap<String, String> matchedAttrs = new HashMap<String, String>();
        for (Map.Entry entry : sourceMbrAttrDataList.entrySet()) {
            for (Map.Entry origAttr : targetMbrAttrDataList.entrySet()) {
                if (!StringUtils.equals((String)((String)origAttr.getKey()), (String)((String)entry.getKey())) || !StringUtils.equals((String)((String)origAttr.getValue()), (String)((String)entry.getValue()))) continue;
                matchedAttrs.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (matchedAttrs.size() != sourceMbrAttrDataList.size()) {
            return false;
        }
        int n2 = targetMbrBo.getRoleRspActions() == null ? 0 : targetMbrBo.getRoleRspActions().size();
        int n3 = n = this.getRoleRspActions() == null ? 0 : this.getRoleRspActions().size();
        if (n2 != n) {
            return false;
        }
        if (n != 0) {
            ArrayList<RoleResponsibilityActionBo> matchedRspActions = new ArrayList<RoleResponsibilityActionBo>();
            for (RoleResponsibilityActionBo newAction : this.getRoleRspActions()) {
                for (RoleResponsibilityActionBo origAction : targetMbrBo.getRoleRspActions()) {
                    if (!StringUtils.equals((String)origAction.getId(), (String)newAction.getId()) || !origAction.equals(newAction)) continue;
                    matchedRspActions.add(newAction);
                }
            }
            if (matchedRspActions.size() != this.getRoleRspActions().size()) {
                return false;
            }
        }
        return true;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getRoleId() {
        return this._persistence_get_roleId();
    }

    public void setRoleId(String roleId) {
        this._persistence_set_roleId(roleId);
    }

    public List<RoleResponsibilityActionBo> getRoleRspActions() {
        if (this.roleRspActions == null) {
            return new AutoPopulatingList(RoleResponsibilityActionBo.class);
        }
        return this.roleRspActions;
    }

    public void setRoleRspActions(List<RoleResponsibilityActionBo> roleRspActions) {
        this.roleRspActions = roleRspActions;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RoleMemberBo();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "roleId") {
            return this.roleId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "attributeDetails") {
            return this.attributeDetails;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "roleId") {
            this.roleId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "attributeDetails") {
            this.attributeDetails = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_roleId() {
        this._persistence_checkFetched("roleId");
        return this.roleId;
    }

    public void _persistence_set_roleId(String string) {
        this._persistence_checkFetchedForSet("roleId");
        this._persistence_propertyChange("roleId", this.roleId, string);
        this.roleId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public List _persistence_get_attributeDetails() {
        this._persistence_checkFetched("attributeDetails");
        return this.attributeDetails;
    }

    public void _persistence_set_attributeDetails(List list) {
        this._persistence_checkFetchedForSet("attributeDetails");
        this._persistence_propertyChange("attributeDetails", this.attributeDetails, list);
        this.attributeDetails = list;
    }
}

