/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeAttribute;
import org.kuali.rice.kim.api.type.KimTypeContract;
import org.kuali.rice.kim.impl.type.KimTypeAttributeBo;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.springframework.util.AutoPopulatingList;

@Entity
@Table(name="KRIM_TYP_T")
public class KimTypeBo
extends DataObjectBase
implements KimTypeContract,
BusinessObject,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 1L;
    @PortableSequenceGenerator(name="KRIM_TYP_ID_S")
    @GeneratedValue(generator="KRIM_TYP_ID_S")
    @Id
    @Column(name="KIM_TYP_ID")
    private String id;
    @Column(name="SRVC_NM")
    private String serviceName;
    @Column(name="NMSPC_CD")
    private String namespaceCode;
    @Column(name="NM")
    private String name;
    @JoinFetch(value=JoinFetchType.OUTER)
    @OneToMany(targetEntity=KimTypeAttributeBo.class, orphanRemoval=true, cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="KIM_TYP_ID", referencedColumnName="KIM_TYP_ID", insertable=false, updatable=false)
    private List<KimTypeAttributeBo> attributeDefinitions = new AutoPopulatingList(KimTypeAttributeBo.class);
    @Column(name="ACTV_IND")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;

    public static KimType to(KimTypeBo bo) {
        if (bo == null) {
            return null;
        }
        return KimType.Builder.create((KimTypeContract)bo).build();
    }

    public static KimTypeBo from(KimType im) {
        if (im == null) {
            return null;
        }
        KimTypeBo bo = new KimTypeBo();
        bo.setId(im.getId());
        bo.setServiceName(im.getServiceName());
        bo.setNamespaceCode(im.getNamespaceCode());
        bo.setName(im.getName());
        ArrayList<KimTypeAttributeBo> attributeBos = new ArrayList<KimTypeAttributeBo>();
        if (CollectionUtils.isNotEmpty((Collection)im.getAttributeDefinitions())) {
            for (KimTypeAttribute kimTypeAttribute : im.getAttributeDefinitions()) {
                attributeBos.add(KimTypeAttributeBo.from(kimTypeAttribute));
            }
            bo.setAttributeDefinitions(attributeBos);
        }
        bo.setActive(im.isActive());
        bo.setVersionNumber(im.getVersionNumber());
        bo.setObjectId(im.getObjectId());
        return bo;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getServiceName() {
        return this._persistence_get_serviceName();
    }

    public void setServiceName(String serviceName) {
        this._persistence_set_serviceName(serviceName);
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public List<KimTypeAttributeBo> getAttributeDefinitions() {
        return this._persistence_get_attributeDefinitions();
    }

    public void setAttributeDefinitions(List<KimTypeAttributeBo> attributeDefinitions) {
        this._persistence_set_attributeDefinitions(attributeDefinitions);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void refresh() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new KimTypeBo();
    }

    public Object _persistence_get(String string) {
        if (string == "attributeDefinitions") {
            return this.attributeDefinitions;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "serviceName") {
            return this.serviceName;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "attributeDefinitions") {
            this.attributeDefinitions = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "serviceName") {
            this.serviceName = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public List _persistence_get_attributeDefinitions() {
        this._persistence_checkFetched("attributeDefinitions");
        return this.attributeDefinitions;
    }

    public void _persistence_set_attributeDefinitions(List list) {
        this._persistence_checkFetchedForSet("attributeDefinitions");
        this._persistence_propertyChange("attributeDefinitions", this.attributeDefinitions, list);
        this.attributeDefinitions = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this._persistence_propertyChange("namespaceCode", this.namespaceCode, string);
        this.namespaceCode = string;
    }

    public String _persistence_get_serviceName() {
        this._persistence_checkFetched("serviceName");
        return this.serviceName;
    }

    public void _persistence_set_serviceName(String string) {
        this._persistence_checkFetchedForSet("serviceName");
        this._persistence_propertyChange("serviceName", this.serviceName, string);
        this.serviceName = string;
    }
}

