/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.responsibility;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.api.responsibility.ResponsibilityActionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="responsibilityAction")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ResponsibilityActionType", propOrder={"principalId", "roleResponsibilityActionId", "parallelRoutingGroupingCode", "actionTypeCode", "actionPolicyCode", "priorityNumber", "groupId", "memberRoleId", "responsibilityName", "responsibilityId", "responsibilityNamespaceCode", "forceAction", "qualifier", "delegates", "roleId", "_futureElements"})
public final class ResponsibilityAction
extends AbstractDataTransferObject
implements ResponsibilityActionContract {
    @XmlElement(name="principalId", required=false)
    private final String principalId;
    @XmlElement(name="roleResponsibilityActionId", required=false)
    private final String roleResponsibilityActionId;
    @XmlElement(name="parallelRoutingGroupingCode", required=false)
    private final String parallelRoutingGroupingCode;
    @XmlElement(name="actionTypeCode", required=false)
    private final String actionTypeCode;
    @XmlElement(name="actionPolicyCode", required=false)
    private final String actionPolicyCode;
    @XmlElement(name="priorityNumber", required=false)
    private final Integer priorityNumber;
    @XmlElement(name="groupId", required=true)
    private final String groupId;
    @XmlElement(name="memberRoleId", required=true)
    private final String memberRoleId;
    @XmlElement(name="responsibilityName", required=true)
    private final String responsibilityName;
    @XmlElement(name="responsibilityId", required=true)
    private final String responsibilityId;
    @XmlElement(name="responsibilityNamespaceCode", required=true)
    private final String responsibilityNamespaceCode;
    @XmlElement(name="forceAction", required=true)
    private final boolean forceAction;
    @XmlElement(name="qualifier", required=true)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> qualifier;
    @XmlElementWrapper(name="delegates", required=false)
    @XmlElement(name="delegate", required=true)
    private final List<DelegateType> delegates;
    @XmlElement(name="roleId", required=true)
    private final String roleId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ResponsibilityAction() {
        this.principalId = null;
        this.roleResponsibilityActionId = null;
        this.parallelRoutingGroupingCode = null;
        this.actionTypeCode = null;
        this.actionPolicyCode = null;
        this.priorityNumber = null;
        this.groupId = null;
        this.memberRoleId = null;
        this.responsibilityName = null;
        this.responsibilityId = null;
        this.responsibilityNamespaceCode = null;
        this.forceAction = false;
        this.qualifier = null;
        this.delegates = null;
        this.roleId = null;
    }

    private ResponsibilityAction(Builder builder) {
        this.principalId = builder.getPrincipalId();
        this.roleResponsibilityActionId = builder.getRoleResponsibilityActionId();
        this.parallelRoutingGroupingCode = builder.getParallelRoutingGroupingCode();
        this.actionTypeCode = builder.getActionTypeCode();
        this.actionPolicyCode = builder.getActionPolicyCode();
        this.priorityNumber = builder.getPriorityNumber();
        this.groupId = builder.getGroupId();
        this.memberRoleId = builder.getMemberRoleId();
        this.responsibilityName = builder.getResponsibilityName();
        this.responsibilityId = builder.getResponsibilityId();
        this.responsibilityNamespaceCode = builder.getResponsibilityNamespaceCode();
        this.forceAction = builder.isForceAction();
        this.qualifier = builder.getQualifier();
        ArrayList<DelegateType> ds = new ArrayList<DelegateType>();
        for (DelegateType.Builder d : builder.getDelegates()) {
            if (d == null) continue;
            ds.add(d.build());
        }
        this.delegates = ds;
        this.roleId = builder.getRoleId();
    }

    @Override
    public String getPrincipalId() {
        return this.principalId;
    }

    @Override
    public String getRoleResponsibilityActionId() {
        return this.roleResponsibilityActionId;
    }

    @Override
    public String getParallelRoutingGroupingCode() {
        return this.parallelRoutingGroupingCode;
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getActionPolicyCode() {
        return this.actionPolicyCode;
    }

    @Override
    public Integer getPriorityNumber() {
        return this.priorityNumber;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getMemberRoleId() {
        return this.memberRoleId;
    }

    @Override
    public String getResponsibilityName() {
        return this.responsibilityName;
    }

    @Override
    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    @Override
    public String getResponsibilityNamespaceCode() {
        return this.responsibilityNamespaceCode;
    }

    @Override
    public boolean isForceAction() {
        return this.forceAction;
    }

    @Override
    public Map<String, String> getQualifier() {
        return this.qualifier;
    }

    public List<DelegateType> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    @Override
    public String getRoleId() {
        return this.roleId;
    }

    static class Elements {
        static final String PRINCIPAL_ID = "principalId";
        static final String ROLE_RESPONSIBILITY_ACTION_ID = "roleResponsibilityActionId";
        static final String PARALLEL_ROUTING_GROUPING_CODE = "parallelRoutingGroupingCode";
        static final String ACTION_TYPE_CODE = "actionTypeCode";
        static final String ACTION_POLICY_CODE = "actionPolicyCode";
        static final String PRIORITY_NUMBER = "priorityNumber";
        static final String GROUP_ID = "groupId";
        static final String MEMBER_ROLE_ID = "memberRoleId";
        static final String RESPONSIBILITY_NAME = "responsibilityName";
        static final String RESPONSIBILITY_ID = "responsibilityId";
        static final String RESPONSIBILITY_NAMESPACE_CODE = "responsibilityNamespaceCode";
        static final String FORCE_ACTION = "forceAction";
        static final String QUALIFIER = "qualifier";
        static final String DELEGATES = "delegates";
        static final String DELEGATE = "delegate";
        static final String ROLE_ID = "roleId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "responsibilityAction";
        static final String TYPE_NAME = "ResponsibilityActionType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    ResponsibilityActionContract {
        private String principalId;
        private String roleResponsibilityActionId;
        private String parallelRoutingGroupingCode;
        private String actionTypeCode;
        private String actionPolicyCode;
        private Integer priorityNumber;
        private String groupId;
        private String memberRoleId;
        private String responsibilityName;
        private String responsibilityId;
        private String responsibilityNamespaceCode;
        private boolean forceAction;
        private Map<String, String> qualifier;
        private List<DelegateType.Builder> delegates;
        private String roleId;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ResponsibilityActionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setPrincipalId(contract.getPrincipalId());
            builder.setRoleResponsibilityActionId(contract.getRoleResponsibilityActionId());
            builder.setParallelRoutingGroupingCode(contract.getParallelRoutingGroupingCode());
            builder.setActionTypeCode(contract.getActionTypeCode());
            builder.setActionPolicyCode(contract.getActionPolicyCode());
            builder.setPriorityNumber(contract.getPriorityNumber());
            builder.setGroupId(contract.getGroupId());
            builder.setMemberRoleId(contract.getMemberRoleId());
            builder.setResponsibilityName(contract.getResponsibilityName());
            builder.setResponsibilityId(contract.getResponsibilityId());
            builder.setResponsibilityNamespaceCode(contract.getResponsibilityNamespaceCode());
            builder.setForceAction(contract.isForceAction());
            builder.setQualifier(contract.getQualifier());
            ArrayList<DelegateType.Builder> dbs = new ArrayList<DelegateType.Builder>();
            for (DelegateTypeContract delegateTypeContract : contract.getDelegates()) {
                if (delegateTypeContract == null) continue;
                dbs.add(DelegateType.Builder.create(delegateTypeContract));
            }
            builder.setDelegates(dbs);
            builder.setRoleId(contract.getRoleId());
            return builder;
        }

        public ResponsibilityAction build() {
            boolean requiredSet;
            boolean bl = requiredSet = this.groupId != null ^ this.principalId != null && this.memberRoleId != null && this.responsibilityName != null && this.responsibilityId != null && this.responsibilityNamespaceCode != null && this.delegates != null && this.roleId != null;
            if (!requiredSet) {
                throw new IllegalStateException("all the required fields are not set");
            }
            return new ResponsibilityAction(this);
        }

        @Override
        public String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public String getRoleResponsibilityActionId() {
            return this.roleResponsibilityActionId;
        }

        @Override
        public String getParallelRoutingGroupingCode() {
            return this.parallelRoutingGroupingCode;
        }

        @Override
        public String getActionTypeCode() {
            return this.actionTypeCode;
        }

        @Override
        public String getActionPolicyCode() {
            return this.actionPolicyCode;
        }

        @Override
        public Integer getPriorityNumber() {
            return this.priorityNumber;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getMemberRoleId() {
            return this.memberRoleId;
        }

        @Override
        public String getResponsibilityName() {
            return this.responsibilityName;
        }

        @Override
        public String getResponsibilityId() {
            return this.responsibilityId;
        }

        @Override
        public String getResponsibilityNamespaceCode() {
            return this.responsibilityNamespaceCode;
        }

        @Override
        public boolean isForceAction() {
            return this.forceAction;
        }

        @Override
        public Map<String, String> getQualifier() {
            return this.qualifier;
        }

        public List<DelegateType.Builder> getDelegates() {
            return Collections.unmodifiableList(this.delegates);
        }

        @Override
        public String getRoleId() {
            return this.roleId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public void setRoleResponsibilityActionId(String roleResponsibilityActionId) {
            this.roleResponsibilityActionId = roleResponsibilityActionId;
        }

        public void setParallelRoutingGroupingCode(String parallelRoutingGroupingCode) {
            this.parallelRoutingGroupingCode = parallelRoutingGroupingCode;
        }

        public void setActionTypeCode(String actionTypeCode) {
            this.actionTypeCode = actionTypeCode;
        }

        public void setActionPolicyCode(String actionPolicyCode) {
            this.actionPolicyCode = actionPolicyCode;
        }

        public void setPriorityNumber(Integer priorityNumber) {
            this.priorityNumber = priorityNumber;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setMemberRoleId(String memberRoleId) {
            if (StringUtils.isBlank((String)memberRoleId)) {
                throw new IllegalArgumentException("memberRoleId is blank");
            }
            this.memberRoleId = memberRoleId;
        }

        public void setResponsibilityName(String responsibilityName) {
            if (StringUtils.isBlank((String)responsibilityName)) {
                throw new IllegalArgumentException("responsibilityName is blank");
            }
            this.responsibilityName = responsibilityName;
        }

        public void setResponsibilityId(String responsibilityId) {
            if (StringUtils.isBlank((String)responsibilityId)) {
                throw new IllegalArgumentException("responsibilityId is blank");
            }
            this.responsibilityId = responsibilityId;
        }

        public void setResponsibilityNamespaceCode(String responsibilityNamespaceCode) {
            if (StringUtils.isBlank((String)responsibilityNamespaceCode)) {
                throw new IllegalArgumentException("responsibilityNamespaceCode is blank");
            }
            this.responsibilityNamespaceCode = responsibilityNamespaceCode;
        }

        public void setForceAction(boolean forceAction) {
            this.forceAction = forceAction;
        }

        public void setQualifier(Map<String, String> qualifier) {
            this.qualifier = qualifier != null ? Collections.unmodifiableMap(Maps.newHashMap(qualifier)) : qualifier;
        }

        public void setDelegates(List<DelegateType.Builder> delegates) {
            if (delegates == null) {
                throw new IllegalArgumentException("delegates is null");
            }
            this.delegates = new ArrayList<DelegateType.Builder>(delegates);
        }

        public void setRoleId(String roleId) {
            if (StringUtils.isBlank((String)roleId)) {
                throw new IllegalArgumentException("roleId is blank");
            }
            this.roleId = roleId;
        }
    }
}

