/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.kuali.rice.ken.bo.NotificationContentTypeBo;
import org.kuali.rice.ken.service.NotificationContentTypeService;
import org.kuali.rice.ken.util.ContentTypeResourceResolver;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ContentTypeLSResourceResolver
extends ContentTypeResourceResolver
implements LSResourceResolver {
    public ContentTypeLSResourceResolver(NotificationContentTypeService notificationContentTypeService) {
        super(notificationContentTypeService);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (!type.equals("http://www.w3.org/2001/XMLSchema")) {
            return null;
        }
        if (!systemId.startsWith("resource:notification/ContentType")) {
            this.LOG.warn("Cannot resolve non-ContentType resources");
            return null;
        }
        NotificationContentTypeBo notificationContentType = this.resolveContentType(systemId);
        if (notificationContentType == null) {
            this.LOG.error("Unable to resolve system id '" + systemId + "' locally...delegating to default resolution strategy.");
            return null;
        }
        StringReader reader = new StringReader(notificationContentType.getXsd());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DOMImplementationLS dils = (DOMImplementationLS)((Object)domImpl);
            LSInput input = dils.createLSInput();
            input.setCharacterStream(reader);
            return input;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

