/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ken.util;

import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.DefaultPropertiesPersister;

public class NotificationPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final String CFG_LOCATION_PROPERTY = "notification.config";

    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        return this.transformProperties(properties);
    }

    protected Properties transformProperties(Properties properties) throws IOException {
        Resource resource;
        String cfgLocation = System.getProperty(CFG_LOCATION_PROPERTY);
        if (cfgLocation != null && (resource = new FileSystemResourceLoader().getResource(cfgLocation)) != null && resource.exists()) {
            new DefaultPropertiesPersister().load(properties, resource.getInputStream());
        }
        return properties;
    }
}

