/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.docsearch;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeFactory;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeInteger;
import org.kuali.rice.kew.docsearch.SearchableAttributeNumericBase;
import org.kuali.rice.kew.docsearch.SearchableAttributeValue;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="KREW_DOC_HDR_EXT_LONG_T")
@NamedQueries(value={@NamedQuery(name="SearchableAttributeLongValue.FindByDocumentId", query="select s from SearchableAttributeLongValue as s where s.documentId = :documentId"), @NamedQuery(name="SearchableAttributeLongValue.FindByKey", query="select s from SearchableAttributeLongValue as s where s.documentId = :documentId and s.searchableAttributeKey = :searchableAttributeKey")})
@AttributeOverrides(value={@AttributeOverride(name="searchableAttributeValueId", column=@Column(name="DOC_HDR_EXT_LONG_ID"))})
public class SearchableAttributeLongValue
extends SearchableAttributeNumericBase
implements SearchableAttributeValue,
Serializable,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final long serialVersionUID = 5786144436732198346L;
    private static final String ATTRIBUTE_DATABASE_TABLE_NAME = "KREW_DOC_HDR_EXT_LONG_T";
    private static final boolean DEFAULT_WILDCARD_ALLOWANCE_POLICY = false;
    private static final boolean ALLOWS_RANGE_SEARCH = true;
    private static final boolean ALLOWS_CASE_INSENSITIVE_SEARCH = false;
    private static final String ATTRIBUTE_XML_REPRESENTATION = "long";
    private static final String DEFAULT_FORMAT_PATTERN = "#";
    private static final String DEFAULT_VALIDATION_REGEX_EXPRESSION = "^-?[0-9]+$";
    private static final Pattern defaultValidationPattern = Pattern.compile("^-?[0-9]+$");
    @Column(name="VAL")
    private Long searchableAttributeValue;

    public SearchableAttributeLongValue() {
        this.ojbConcreteClass = this.getClass().getName();
    }

    @Override
    public void setupAttributeValue(String value) {
        this.setSearchableAttributeValue(this.convertStringToLong(value));
    }

    private Long convertStringToLong(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return Long.valueOf(value.trim());
    }

    @Override
    public void setupAttributeValue(ResultSet resultSet, String columnName) throws SQLException {
        this.setSearchableAttributeValue(resultSet.getLong(columnName));
    }

    @Override
    public String getSearchableAttributeDisplayValue() {
        NumberFormat format = DecimalFormat.getInstance();
        ((DecimalFormat)format).applyPattern(DEFAULT_FORMAT_PATTERN);
        return format.format(this.getSearchableAttributeValue());
    }

    @Override
    public String getAttributeDataType() {
        return ATTRIBUTE_XML_REPRESENTATION;
    }

    @Override
    public String getAttributeTableName() {
        return ATTRIBUTE_DATABASE_TABLE_NAME;
    }

    @Override
    public boolean allowsWildcards() {
        return false;
    }

    @Override
    public boolean allowsCaseInsensitivity() {
        return false;
    }

    @Override
    public boolean allowsRangeSearches() {
        return true;
    }

    @Override
    public Boolean isRangeValid(String lowerValue, String upperValue) {
        if (this.allowsRangeSearches()) {
            Long lower = this.convertStringToLong(lowerValue);
            Long upper = this.convertStringToLong(upperValue);
            if (lower != null && upper != null) {
                return lower.compareTo(upper) <= 0;
            }
            return true;
        }
        return null;
    }

    @Override
    public Long getSearchableAttributeValue() {
        return this._persistence_get_searchableAttributeValue();
    }

    public void setSearchableAttributeValue(Long searchableAttributeValue) {
        this._persistence_set_searchableAttributeValue(searchableAttributeValue);
    }

    public DocumentAttributeInteger toDocumentAttribute() {
        BigInteger integer = null;
        if (this.getSearchableAttributeValue() != null) {
            integer = BigInteger.valueOf(this.getSearchableAttributeValue());
        }
        return DocumentAttributeFactory.createIntegerAttribute((String)this.getSearchableAttributeKey(), integer);
    }

    @Override
    protected Pattern getDefaultValidationPattern() {
        return defaultValidationPattern;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new SearchableAttributeLongValue();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "searchableAttributeValue") {
            return this.searchableAttributeValue;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "searchableAttributeValue") {
            this.searchableAttributeValue = (Long)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Long _persistence_get_searchableAttributeValue() {
        this._persistence_checkFetched("searchableAttributeValue");
        return this.searchableAttributeValue;
    }

    public void _persistence_set_searchableAttributeValue(Long l) {
        this._persistence_checkFetchedForSet("searchableAttributeValue");
        this._persistence_propertyChange("searchableAttributeValue", this.searchableAttributeValue, l);
        this.searchableAttributeValue = l;
    }
}

