/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.DocumentTypePermissionService;
import org.kuali.rice.kew.doctype.service.impl.DocumentActionsPermissionBase;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class DocumentTypePermissionServiceImpl
extends DocumentActionsPermissionBase
implements DocumentTypePermissionService {
    private static final Logger LOG = LogManager.getLogger(DocumentTypePermissionServiceImpl.class);

    @Override
    public boolean canReceiveAdHocRequest(String principalId, DocumentRouteHeaderValue document, String actionRequestType) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        DocumentType documentType = document.getDocumentType();
        this.validateDocumentType(documentType);
        this.validateActionRequestType(actionRequestType);
        Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, actionRequestType, null);
        Boolean result = this.useKimPermission("KR-WKFLW", "Ad Hoc Review Document", permissionDetails, true) ? Boolean.valueOf(this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Ad Hoc Review Document", permissionDetails, new HashMap())) : Boolean.TRUE;
        return result;
    }

    @Override
    public boolean canGroupReceiveAdHocRequest(String groupId, DocumentRouteHeaderValue document, String actionRequestType) {
        this.validateGroupId(groupId);
        this.validateDocument(document);
        DocumentType documentType = document.getDocumentType();
        this.validateDocumentType(documentType);
        this.validateActionRequestType(actionRequestType);
        Boolean result = Boolean.TRUE;
        Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, actionRequestType, null);
        if (this.useKimPermission("KR-WKFLW", "Ad Hoc Review Document", permissionDetails, true)) {
            List principalIds = this.getGroupService().getMemberPrincipalIds(groupId);
            for (String principalId : principalIds) {
                if (this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Ad Hoc Review Document", permissionDetails, new HashMap())) continue;
                result = Boolean.FALSE;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean canAdministerRouting(String principalId, DocumentType documentType) {
        Boolean result;
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        if (documentType.isSuperUserGroupDefined()) {
            result = documentType.isSuperUser(principalId);
        } else {
            Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, null, null);
            result = this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Administer Routing for Document", permissionDetails, new HashMap());
        }
        return result;
    }

    @Override
    public boolean canSuperUserApproveSingleActionRequest(String principalId, DocumentType documentType, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        return this.canSuperUserApproveSingleActionRequest(principalId, documentType, this.toRouteNodeNames(routeNodeInstances), routeStatusCode);
    }

    @Override
    public boolean canSuperUserApproveDocument(String principalId, DocumentType documentType, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        return this.canSuperUserApproveDocument(principalId, documentType, this.toRouteNodeNames(routeNodeInstances), routeStatusCode);
    }

    @Override
    public boolean canSuperUserDisapproveDocument(String principalId, DocumentType documentType, List<RouteNodeInstance> routeNodeInstances, String routeStatusCode) {
        return this.canSuperUserDisapproveDocument(principalId, documentType, this.toRouteNodeNames(routeNodeInstances), routeStatusCode);
    }

    @Override
    public boolean canAddRouteLogMessage(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        String documentId = document.getDocumentId();
        DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String initiatorPrincipalId = document.getInitiatorWorkflowId();
        this.validateDocumentType(documentType);
        this.validateDocumentStatus(documentStatus);
        this.validatePrincipalId(initiatorPrincipalId);
        Map<String, String> permissionDetails = this.buildDocumentTypePermissionDetails(documentType, documentStatus, null, null);
        Map<String, String> roleQualifiers = this.buildDocumentRoleQualifiers(document, permissionDetails.get("routeNodeName"));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Permission details values: " + permissionDetails);
            LOG.debug("Role qualifiers values: " + roleQualifiers);
        }
        if (this.useKimPermission("KR-WKFLW", "Add Message to Route Log", permissionDetails, false)) {
            return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Add Message to Route Log", permissionDetails, roleQualifiers);
        }
        return false;
    }

    @Override
    public boolean canReturnToPreviousRouteNode(String principalId, DocumentRouteHeaderValue document) {
        return false;
    }

    protected Collection<String> toRouteNodeNames(Collection<RouteNodeInstance> routeNodeInstances) {
        if (routeNodeInstances != null) {
            return CollectionUtils.collect(routeNodeInstances, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ((RouteNodeInstance)input).getName();
                }
            });
        }
        return Collections.EMPTY_LIST;
    }

    private void validateGroupId(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("Invalid group ID, value was empty");
        }
    }

    private void validateActionRequestType(String actionRequestType) {
        if (StringUtils.isBlank((String)actionRequestType)) {
            throw new IllegalArgumentException("Invalid action request type, value was empty");
        }
        if (!KewApiConstants.ACTION_REQUEST_CODES.containsKey(actionRequestType)) {
            throw new IllegalArgumentException("Invalid action request type was given, value was: " + actionRequestType);
        }
    }

    protected GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }
}

