/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.doctype.IllegalDocumentTypeException;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.CompatUtils;
import org.kuali.rice.kew.engine.EngineState;
import org.kuali.rice.kew.engine.OrchestrationConfig;
import org.kuali.rice.kew.engine.ProcessContext;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.WorkflowEngine;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.RouteNodeUtils;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.engine.transition.Transition;
import org.kuali.rice.kew.engine.transition.TransitionEngine;
import org.kuali.rice.kew.engine.transition.TransitionEngineFactory;
import org.kuali.rice.kew.exception.RouteManagerException;
import org.kuali.rice.kew.framework.postprocessor.AfterProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.BeforeProcessEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentLockingEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.krad.data.KradDataServiceLocator;

public class StandardWorkflowEngine
implements WorkflowEngine {
    private static final Logger LOG = LogManager.getLogger(StandardWorkflowEngine.class);
    protected final RouteHelper helper = new RouteHelper();
    protected RouteNodeService routeNodeService;
    protected RouteHeaderService routeHeaderService;
    protected ParameterService parameterService;
    protected OrchestrationConfig config;

    public StandardWorkflowEngine() {
    }

    protected StandardWorkflowEngine(RouteNodeService routeNodeService, RouteHeaderService routeHeaderService, ParameterService parameterService, OrchestrationConfig config) {
        this.routeNodeService = routeNodeService;
        this.routeHeaderService = routeHeaderService;
        this.parameterService = parameterService;
        this.config = config;
    }

    public boolean isRunPostProcessorLogic() {
        return this.config.isRunPostProcessorLogic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String documentId) throws Exception {
        DocumentRouteHeaderValue document;
        RouteContext context;
        boolean success;
        block21: {
            if (documentId == null) {
                throw new IllegalArgumentException("Cannot process a null document id.");
            }
            ThreadContext.put((String)"docId", (String)documentId);
            success = true;
            context = RouteContext.createNewRouteContext();
            if (LOG.isInfoEnabled()) {
                LOG.info("Aquiring lock on document " + documentId);
            }
            KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
            if (LOG.isInfoEnabled()) {
                LOG.info("Aquired lock on document " + documentId);
            }
            document = this.getRouteHeaderService().getRouteHeader(documentId);
            context.setDocument(document);
            this.lockAdditionalDocuments(document);
            if (LOG.isInfoEnabled()) {
                LOG.info("Processing document: " + documentId);
            }
            try {
                document = this.notifyPostProcessorBeforeProcess(document);
                context.setDocument(document);
            }
            catch (Exception e) {
                LOG.warn("Problems contacting PostProcessor before engine process", (Throwable)e);
                throw new RouteManagerException("Problems contacting PostProcessor:  " + e.getMessage(), e);
            }
            if (document.isRoutable()) break block21;
            LOG.debug("Document not routable so returning with doing no action");
            if (LOG.isInfoEnabled()) {
                LOG.info((success ? "Successfully processed" : "Failed to process") + " document: " + documentId);
            }
            try {
                this.notifyPostProcessorAfterProcess(context.getDocument(), success);
            }
            catch (Exception e) {
                LOG.warn("Problems contacting PostProcessor after engine process", (Throwable)e);
                throw new RouteManagerException("Problems contacting PostProcessor", e, context);
            }
            RouteContext.clearCurrentRouteContext();
            ThreadContext.remove((String)"docId");
            return;
        }
        try {
            LinkedList<RouteNodeInstance> nodeInstancesToProcess = new LinkedList<RouteNodeInstance>();
            nodeInstancesToProcess.addAll(RouteNodeUtils.getActiveNodeInstances(document));
            context.setEngineState(new EngineState());
            try {
                while (!nodeInstancesToProcess.isEmpty()) {
                    context.setNodeInstance((RouteNodeInstance)nodeInstancesToProcess.remove(0));
                    ProcessContext processContext = this.processNodeInstance(context, this.helper);
                    if (!processContext.isComplete() || processContext.getNextNodeInstances().isEmpty()) continue;
                    nodeInstancesToProcess.addAll(processContext.getNextNodeInstances());
                }
                context.setDocument(this.nodePostProcess(context));
                this.flushDatabaseWork(context);
            }
            catch (Exception e) {
                success = false;
                throw new RouteManagerException(e, context);
            }
        }
        catch (Throwable throwable) {
            if (LOG.isInfoEnabled()) {
                LOG.info((success ? "Successfully processed" : "Failed to process") + " document: " + documentId);
            }
            try {
                this.notifyPostProcessorAfterProcess(context.getDocument(), success);
            }
            catch (Exception e) {
                LOG.warn("Problems contacting PostProcessor after engine process", (Throwable)e);
                throw new RouteManagerException("Problems contacting PostProcessor", e, context);
            }
            RouteContext.clearCurrentRouteContext();
            ThreadContext.remove((String)"docId");
            throw throwable;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((success ? "Successfully processed" : "Failed to process") + " document: " + documentId);
        }
        try {
            this.notifyPostProcessorAfterProcess(context.getDocument(), success);
        }
        catch (Exception e) {
            LOG.warn("Problems contacting PostProcessor after engine process", (Throwable)e);
            throw new RouteManagerException("Problems contacting PostProcessor", e, context);
        }
        RouteContext.clearCurrentRouteContext();
        ThreadContext.remove((String)"docId");
    }

    protected ProcessContext processNodeInstance(RouteContext context, RouteHelper helper) throws Exception {
        RouteNodeInstance nodeInstance = context.getNodeInstance();
        nodeInstance = this.saveNode(context, nodeInstance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing node instance: " + nodeInstance.getRouteNode().getRouteNodeName());
        }
        if (this.checkAssertions(context)) {
            return new ProcessContext();
        }
        TransitionEngine transitionEngine = TransitionEngineFactory.createTransitionEngine(nodeInstance);
        ProcessResult processResult = transitionEngine.isComplete(context);
        if (nodeInstance.isInitial()) {
            nodeInstance.setInitial(false);
        }
        if (processResult.isComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Routing node has completed: " + nodeInstance.getRouteNode().getRouteNodeName());
            }
            if (nodeInstance.getRouteNodeInstanceId() == null) {
                throw new IllegalStateException("Encountered a node instance in the engine with no id: " + nodeInstance);
            }
            context.getEngineState().getCompleteNodeInstances().add(nodeInstance.getRouteNodeInstanceId());
            List<RouteNodeInstance> nextNodeCandidates = this.invokeTransition(context, nodeInstance, processResult, transitionEngine);
            ArrayList<RouteNodeInstance> nodesToActivate = new ArrayList<RouteNodeInstance>();
            if (!nextNodeCandidates.isEmpty()) {
                for (RouteNodeInstance nextNodeInstance : nextNodeCandidates) {
                    RouteNodeInstance savedNextNodeInstance;
                    RouteNodeInstance currentNextNodeInstance = nextNodeInstance;
                    transitionEngine = TransitionEngineFactory.createTransitionEngine(nextNodeInstance);
                    if (!currentNextNodeInstance.equals(nextNodeInstance = transitionEngine.transitionTo(nextNodeInstance, context))) {
                        nodeInstance.getNextNodeInstances().remove(currentNextNodeInstance);
                        currentNextNodeInstance.getPreviousNodeInstances().remove(nodeInstance);
                    }
                    if ((savedNextNodeInstance = this.saveNode(context, nextNodeInstance)) != nextNodeInstance) {
                        nodeInstance.getNextNodeInstances().remove(nextNodeInstance);
                    }
                    if (!nodeInstance.getNextNodeInstances().contains(savedNextNodeInstance)) {
                        nodeInstance.addNextNodeInstance(savedNextNodeInstance);
                    }
                    this.handleBackwardCompatibility(context, savedNextNodeInstance);
                    this.notifyNodeChange(context, savedNextNodeInstance);
                    nodesToActivate.add(savedNextNodeInstance);
                }
            }
            nodeInstance.setComplete(true);
            nodeInstance.setActive(false);
            for (RouteNodeInstance nodeToActivate : nodesToActivate) {
                nodeToActivate.setActive(true);
            }
        } else {
            nodeInstance.setComplete(false);
        }
        nodeInstance = this.saveNode(context, nodeInstance);
        this.flushDatabaseWork(context);
        return new ProcessContext(nodeInstance.isComplete(), nodeInstance.getNextNodeInstances());
    }

    private boolean checkAssertions(RouteContext context) throws Exception {
        if (context.getNodeInstance().isComplete()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The node has already been completed: " + context.getNodeInstance().getRouteNode().getRouteNodeName());
            }
            return true;
        }
        if (this.isRunawayProcessDetected(context.getEngineState())) {
            throw new WorkflowException("Detected runaway process.");
        }
        return false;
    }

    private List<RouteNodeInstance> invokeTransition(RouteContext context, RouteNodeInstance nodeInstance, ProcessResult processResult, TransitionEngine transitionEngine) throws Exception {
        Transition result;
        List<RouteNodeInstance> nextNodeInstances = nodeInstance.getNextNodeInstances();
        if (nextNodeInstances.isEmpty() && (nextNodeInstances = (result = transitionEngine.transitionFrom(context, processResult)).getNextNodeInstances()).isEmpty() && nodeInstance.isInProcess()) {
            transitionEngine = TransitionEngineFactory.createTransitionEngine(nodeInstance.getProcess());
            context.setNodeInstance(nodeInstance);
            nextNodeInstances = this.invokeTransition(context, nodeInstance.getProcess(), processResult, transitionEngine);
        }
        return nextNodeInstances;
    }

    private void notifyNodeChange(RouteContext context, RouteNodeInstance nextNodeInstance) throws Exception {
        if (!context.isSimulation()) {
            RouteNodeInstance nodeInstance = context.getNodeInstance();
            String nextStatus = nodeInstance.getRouteNode().getNextDocStatus();
            if (nextStatus != null && nextStatus.length() > 0) {
                context.getDocument().updateAppDocStatus(nextStatus);
            }
            DocumentRouteLevelChange event = new DocumentRouteLevelChange(context.getDocument().getDocumentId(), context.getDocument().getAppDocId(), CompatUtils.getLevelForNode(context.getDocument().getDocumentType(), context.getNodeInstance().getRouteNode().getRouteNodeName()), CompatUtils.getLevelForNode(context.getDocument().getDocumentType(), nextNodeInstance.getRouteNode().getRouteNodeName()), nodeInstance.getRouteNode().getRouteNodeName(), nextNodeInstance.getRouteNode().getRouteNodeName(), nodeInstance.getRouteNodeInstanceId(), nextNodeInstance.getRouteNodeInstanceId());
            context.setDocument(this.notifyPostProcessor(context.getDocument(), nodeInstance, event));
        }
    }

    private void handleBackwardCompatibility(RouteContext context, RouteNodeInstance nextNodeInstance) {
        context.getDocument().setDocRouteLevel(new Integer(context.getDocument().getDocRouteLevel() + 1));
        this.saveDocument(context);
    }

    private void saveDocument(RouteContext context) {
        if (!context.isSimulation()) {
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(context.getDocument());
            context.setDocument(routeHeaderValue);
        }
    }

    private Branch saveBranch(RouteContext context, Branch branch) {
        if (!context.isSimulation()) {
            return KEWServiceLocator.getRouteNodeService().save(branch);
        }
        return branch;
    }

    protected RouteNodeInstance saveNode(RouteContext context, RouteNodeInstance nodeInstance) {
        if (!context.isSimulation()) {
            nodeInstance = this.getRouteNodeService().save(nodeInstance);
        } else {
            for (RouteNodeInstance routeNodeInstance : nodeInstance.getNextNodeInstances()) {
                if (routeNodeInstance.getRouteNodeInstanceId() != null) continue;
                routeNodeInstance.setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
            }
            if (nodeInstance.getProcess() != null && nodeInstance.getProcess().getRouteNodeInstanceId() == null) {
                nodeInstance.getProcess().setRouteNodeInstanceId(context.getEngineState().getNextSimulationId());
            }
            if (nodeInstance.getBranch() != null && nodeInstance.getBranch().getBranchId() == null) {
                nodeInstance.getBranch().setBranchId(context.getEngineState().getNextSimulationId());
            }
        }
        return nodeInstance;
    }

    protected void flushDatabaseWork(RouteContext context) {
        if (!context.isSimulation()) {
            KradDataServiceLocator.getDataObjectService().flush(DocumentRouteHeaderValue.class);
        }
    }

    protected DocumentRouteHeaderValue nodePostProcess(RouteContext context) throws InvalidActionTakenException {
        DocumentRouteStatusChange event;
        DocumentRouteHeaderValue document = context.getDocument();
        List<RouteNodeInstance> activeNodes = RouteNodeUtils.getActiveNodeInstances(document);
        boolean moreNodes = false;
        for (RouteNodeInstance nodeInstance : activeNodes) {
            moreNodes = moreNodes || !nodeInstance.isComplete();
        }
        List<ActionRequestValue> pendingRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        boolean activeApproveRequests = false;
        boolean activeAckRequests = false;
        for (ActionRequestValue request : pendingRequests) {
            activeApproveRequests = request.isApproveOrCompleteRequest() || activeApproveRequests;
            activeAckRequests = request.isAcknowledgeRequest() || activeAckRequests;
        }
        if (!(document.isProcessed() || moreNodes && activeApproveRequests)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No more nodes for this document " + document.getDocumentId());
            }
            this.checkDefaultApprovalPolicy(document);
            document.setApprovedDate(new Timestamp(System.currentTimeMillis()));
            LOG.debug("Marking document processed");
            event = new DocumentRouteStatusChange(document.getDocumentId(), document.getAppDocId(), document.getDocRouteStatus(), "P");
            document.markDocumentProcessed();
            this.notifyPostProcessor(context, event);
        }
        if (document.isProcessed()) {
            event = new DocumentRouteStatusChange(document.getDocumentId(), document.getAppDocId(), document.getDocRouteStatus(), "F");
            List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
            if (actionRequests.isEmpty()) {
                document.markDocumentFinalized();
                this.notifyPostProcessor(context, event);
            } else {
                boolean markFinalized = true;
                for (ActionRequestValue actionRequest : actionRequests) {
                    if (!"K".equals(actionRequest.getActionRequested())) continue;
                    markFinalized = false;
                }
                if (markFinalized) {
                    document.markDocumentFinalized();
                    this.notifyPostProcessor(context, event);
                }
            }
        }
        this.saveDocument(context);
        return document;
    }

    private void checkDefaultApprovalPolicy(DocumentRouteHeaderValue document) throws RouteManagerException {
        if (!document.getDocumentType().getDefaultApprovePolicy().getPolicyValue().booleanValue()) {
            LOG.debug("Checking if any requests have been generated for the document");
            List<ActionRequestValue> requests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
            boolean approved = false;
            for (ActionRequestValue actionRequest : requests) {
                if (!actionRequest.isApproveOrCompleteRequest() || !actionRequest.isDone() || document.getInitiatorWorkflowId().equals(actionRequest.getPrincipalId())) continue;
                LOG.debug("Found at least one processed approve or completion request for someone other than the initiator so document can be approved");
                approved = true;
                break;
            }
            if (!approved) {
                LOG.debug("Document requires at least one request and none are present");
                throw new RouteManagerException("Document should have generated at least one approval or completion request for someone other than the initiator.");
            }
        }
    }

    private DocumentRouteHeaderValue notifyPostProcessor(RouteContext context, DocumentRouteStatusChange event) {
        DocumentRouteHeaderValue document = context.getDocument();
        if (context.isSimulation()) {
            return document;
        }
        if (this.hasContactedPostProcessor(context, event)) {
            return document;
        }
        String documentId = event.getDocumentId();
        PerformanceLogger performanceLogger = new PerformanceLogger(documentId);
        ProcessDocReport processReport = null;
        Object postProc = null;
        try {
            postProc = !this.isRunPostProcessorLogic() ? new DefaultPostProcessor() : document.getDocumentType().getPostProcessor();
        }
        catch (Exception e) {
            LOG.error("Error retrieving PostProcessor for document " + document.getDocumentId(), (Throwable)e);
            throw new RouteManagerException("Error retrieving PostProcessor for document " + document.getDocumentId(), e);
        }
        try {
            processReport = postProc.doRouteStatusChange(event);
        }
        catch (Exception e) {
            LOG.error("Error notifying post processor", (Throwable)e);
            throw new RouteManagerException("PostProcessor failed to process document: ", e);
        }
        finally {
            performanceLogger.log("Time to notifyPostProcessor of event " + event.getDocumentEventCode() + ".");
        }
        if (!processReport.isSuccess()) {
            LOG.warn("PostProcessor failed to process document: " + processReport.getMessage());
            throw new RouteManagerException("PostProcessor failed to process document: " + processReport.getMessage());
        }
        return document;
    }

    private boolean hasContactedPostProcessor(RouteContext context, DocumentRouteStatusChange event) {
        Branch rootBranch = context.getDocument().getRootBranch();
        String key = null;
        if ("P".equals(event.getNewRouteStatus())) {
            key = "System.PostProcessorProcessed";
        } else if ("F".equals(event.getNewRouteStatus())) {
            key = "System.PostProcessorFinal";
        } else {
            return false;
        }
        BranchState branchState = null;
        if (rootBranch == null) {
            return false;
        }
        branchState = rootBranch.getBranchState(key);
        if (branchState == null) {
            branchState = new BranchState();
            branchState.setKey(key);
            branchState.setValue("true");
            rootBranch.addBranchState(branchState);
            this.saveBranch(context, rootBranch);
            return false;
        }
        return "true".equals(branchState.getValue());
    }

    private DocumentRouteHeaderValue notifyPostProcessor(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance, DocumentRouteLevelChange event) {
        document = this.getRouteHeaderService().saveRouteHeader(document);
        ProcessDocReport report = null;
        try {
            Object postProcessor = null;
            postProcessor = !this.isRunPostProcessorLogic() ? new DefaultPostProcessor() : document.getDocumentType().getPostProcessor();
            report = postProcessor.doRouteLevelChange(event);
        }
        catch (Exception e) {
            LOG.warn("Problems contacting PostProcessor", (Throwable)e);
            throw new RouteManagerException("Problems contacting PostProcessor:  " + e.getMessage(), e);
        }
        document = this.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        if (!report.isSuccess()) {
            LOG.error("PostProcessor rejected route level change::" + report.getMessage(), (Throwable)report.getProcessException());
            throw new RouteManagerException("Route Level change failed in post processor::" + report.getMessage());
        }
        return document;
    }

    private DocumentRouteHeaderValue notifyPostProcessorBeforeProcess(DocumentRouteHeaderValue document) {
        return this.notifyPostProcessorBeforeProcess(document, new BeforeProcessEvent(document.getDocumentId(), document.getAppDocId()));
    }

    private DocumentRouteHeaderValue notifyPostProcessorBeforeProcess(DocumentRouteHeaderValue document, BeforeProcessEvent event) {
        ProcessDocReport report = null;
        try {
            Object postProcessor = null;
            postProcessor = !this.isRunPostProcessorLogic() ? new DefaultPostProcessor() : document.getDocumentType().getPostProcessor();
            report = postProcessor.beforeProcess(event);
        }
        catch (Exception e) {
            LOG.warn("Problems contacting PostProcessor", (Throwable)e);
            throw new RouteManagerException("Problems contacting PostProcessor:  " + e.getMessage(), e);
        }
        document = this.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        if (!report.isSuccess()) {
            LOG.error("PostProcessor rejected route level change::" + report.getMessage(), (Throwable)report.getProcessException());
            throw new RouteManagerException("Route Level change failed in post processor::" + report.getMessage());
        }
        return document;
    }

    protected void lockAdditionalDocuments(DocumentRouteHeaderValue document) throws Exception {
        DocumentLockingEvent lockingEvent = new DocumentLockingEvent(document.getDocumentId(), document.getAppDocId());
        Object postProcessor = null;
        postProcessor = !this.isRunPostProcessorLogic() ? new DefaultPostProcessor() : document.getDocumentType().getPostProcessor();
        List documentIdsToLock = postProcessor.getDocumentIdsToLock(lockingEvent);
        if (documentIdsToLock != null && !documentIdsToLock.isEmpty()) {
            for (String documentId : documentIdsToLock) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Aquiring additional lock on document " + documentId);
                }
                this.getRouteHeaderService().lockRouteHeader(documentId);
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Aquired lock on document " + documentId);
            }
        }
    }

    private DocumentRouteHeaderValue notifyPostProcessorAfterProcess(DocumentRouteHeaderValue document, boolean successfullyProcessed) {
        if (document == null) {
            return null;
        }
        return this.notifyPostProcessorAfterProcess(document, new AfterProcessEvent(document.getDocumentId(), document.getAppDocId(), successfullyProcessed));
    }

    private DocumentRouteHeaderValue notifyPostProcessorAfterProcess(DocumentRouteHeaderValue document, AfterProcessEvent event) {
        ProcessDocReport report = null;
        try {
            Object postProcessor = null;
            postProcessor = !this.isRunPostProcessorLogic() ? new DefaultPostProcessor() : document.getDocumentType().getPostProcessor();
            report = postProcessor.afterProcess(event);
        }
        catch (Exception e) {
            throw new RouteManagerException("Problems contacting PostProcessor.", e);
        }
        document = this.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        if (!report.isSuccess()) {
            LOG.error("PostProcessor rejected route level change::" + report.getMessage(), (Throwable)report.getProcessException());
            throw new RouteManagerException("Route Level change failed in post processor::" + report.getMessage());
        }
        return document;
    }

    @Override
    public void initializeDocument(DocumentRouteHeaderValue document) {
        ProcessDefinitionBo process;
        RouteContext context = new RouteContext();
        context.setDocument(document);
        if (context.getEngineState() == null) {
            context.setEngineState(new EngineState());
        }
        if ((process = document.getDocumentType().getPrimaryProcess()) == null) {
            throw new IllegalDocumentTypeException("DocumentType '" + document.getDocumentType().getName() + "' has no primary process configured!");
        }
        if (process.getInitialRouteNode() != null) {
            RouteNodeInstance nodeInstance = this.helper.getNodeFactory().createRouteNodeInstance(document.getDocumentId(), process.getInitialRouteNode());
            nodeInstance.setActive(true);
            this.helper.getNodeFactory().createBranch("PRIMARY", null, nodeInstance);
            nodeInstance = this.saveNode(context, nodeInstance);
            document.getInitialRouteNodeInstances().add(nodeInstance);
        }
    }

    private boolean isRunawayProcessDetected(EngineState engineState) throws NumberFormatException {
        String maxNodesConstant = this.getParameterService().getParameterValueAsString("KR-WKFLW", "All", "MAXIMUM_NODES_BEFORE_RUNAWAY");
        int maxNodes = StringUtils.isEmpty((String)maxNodesConstant) ? 50 : Integer.valueOf(maxNodesConstant);
        return engineState.getCompleteNodeInstances().size() > maxNodes;
    }

    protected RouteNodeService getRouteNodeService() {
        return this.routeNodeService;
    }

    protected RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public void setRouteNodeService(RouteNodeService routeNodeService) {
        this.routeNodeService = routeNodeService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

