/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemodule.service.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.role.RoleRouteModule;
import org.kuali.rice.kew.routemodule.FlexRMAdapter;
import org.kuali.rice.kew.routemodule.RouteModule;
import org.kuali.rice.kew.routemodule.service.RouteModuleService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class RouteModuleServiceImpl
implements RouteModuleService,
BeanFactoryAware {
    private static final Logger LOG = LogManager.getLogger(RouteModuleServiceImpl.class);
    private BeanFactory beanFactory;
    private String rulesEngineRouteModuleId;
    private RouteModule peopleFlowRouteModule;
    private volatile RouteModule rulesEngineRouteModule;

    @Override
    public RouteModule findRouteModule(RouteNode node) throws ResourceUnavailableException {
        String routeMethodName = node.getRouteMethodName();
        LOG.debug("Finding route module for routeMethodName=" + routeMethodName + " at route level " + node.getRouteNodeName());
        RouteModule routeModule = null;
        routeModule = node.isRulesEngineNode() ? this.getRulesEngineRouteModule() : (node.isPeopleFlowNode() ? this.getPeopleFlowRouteModule() : (routeMethodName == null || node.isFlexRM() ? this.getFlexRMRouteModule(routeMethodName) : this.getRouteModule(routeMethodName)));
        return routeModule;
    }

    @Override
    public RouteModule findRouteModule(ActionRequestValue actionRequest) throws ResourceUnavailableException {
        if (!actionRequest.getResolveResponsibility()) {
            return new RoleRouteModule();
        }
        if (actionRequest.getNodeInstance() == null) {
            return null;
        }
        return this.findRouteModule(actionRequest.getNodeInstance().getRouteNode());
    }

    private RouteModule getRouteModule(String routeMethodName) throws ResourceUnavailableException {
        if (routeMethodName == null) {
            return null;
        }
        if ("".equals(routeMethodName.trim()) || "NONE".equals(routeMethodName)) {
            return null;
        }
        Object routeModule = GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(routeMethodName));
        if (routeModule instanceof RouteModule) {
            return (RouteModule)routeModule;
        }
        throw new WorkflowRuntimeException("Could not locate the Route Module with the given name: " + routeMethodName);
    }

    private RouteModule getFlexRMRouteModule(String ruleTemplateName) {
        return new FlexRMAdapter();
    }

    public void setPeopleFlowRouteModule(RouteModule peopleFlowRouteModule) {
        this.peopleFlowRouteModule = peopleFlowRouteModule;
    }

    public RouteModule getPeopleFlowRouteModule() {
        return this.peopleFlowRouteModule;
    }

    public String getRulesEngineRouteModuleId() {
        return this.rulesEngineRouteModuleId;
    }

    public void setRulesEngineRouteModuleId(String rulesEngineRouteModuleId) {
        this.rulesEngineRouteModuleId = rulesEngineRouteModuleId;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected RouteModule getRulesEngineRouteModule() {
        if (this.rulesEngineRouteModule == null) {
            this.rulesEngineRouteModule = (RouteModule)this.beanFactory.getBean(this.getRulesEngineRouteModuleId());
        }
        return this.rulesEngineRouteModule;
    }
}

