/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.framework.state;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;

public class StateValuesFinder
extends KeyValuesBase {
    private String countryCode = "";

    public List<KeyValue> getKeyValues() {
        Country defaultCountry;
        if (StringUtils.isEmpty((String)this.countryCode) && (defaultCountry = LocationApiServiceLocator.getCountryService().getDefaultCountry()) != null) {
            this.countryCode = defaultCountry.getCode();
        }
        List baseCodes = LocationApiServiceLocator.getStateService().findAllStatesInCountry(this.countryCode);
        return Stream.concat(Stream.of(new ConcreteKeyValue("", "")), baseCodes.stream().filter(State::isActive).map(state -> new ConcreteKeyValue(state.getCode(), this.getName((State)state))).sorted(Comparator.comparing(KeyValue::getValue))).collect(Collectors.toList());
    }

    private String getName(State state) {
        return StringUtils.isNotBlank((String)state.getNameV3()) ? state.getNameV3() : state.getName();
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void clearInternalCache() {
    }
}

