/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerEvent;

public final class PBLifeCycleEvent
extends PersistenceBrokerEvent {
    public static final int TYPE_BEFORE_INSERT = 1;
    public static final int TYPE_BEFORE_DELETE = 2;
    public static final int TYPE_BEFORE_UPDATE = 3;
    public static final int TYPE_AFTER_UPDATE = 4;
    public static final int TYPE_AFTER_DELETE = 5;
    public static final int TYPE_AFTER_LOOKUP = 6;
    public static final int TYPE_AFTER_INSERT = 7;
    private Type eventType;
    private Object target;

    public PBLifeCycleEvent(PersistenceBroker persistenceBroker, Object object, Type type) {
        super(persistenceBroker);
        this.target = object;
        this.eventType = type;
    }

    public PBLifeCycleEvent(PersistenceBroker persistenceBroker, Type type) {
        super(persistenceBroker);
        this.eventType = type;
    }

    public PersistenceBrokerAware getPersitenceBrokerAware() {
        if (this.target != null && this.target instanceof PersistenceBrokerAware) {
            return (PersistenceBrokerAware)this.target;
        }
        return null;
    }

    public void setTarget(Object object) {
        this.target = object;
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        toStringBuilder.append("target object", this.target).append("source object", this.getSource()).append("eventType", (Object)this.eventType.toString());
        return toStringBuilder.toString();
    }

    public Type getEventType() {
        return this.eventType;
    }

    public static class Type {
        public static final Type BEFORE_INSERT = new Type(1);
        public static final Type BEFORE_UPDATE = new Type(3);
        public static final Type AFTER_INSERT = new Type(7);
        public static final Type AFTER_UPDATE = new Type(4);
        public static final Type BEFORE_DELETE = new Type(2);
        public static final Type AFTER_DELETE = new Type(5);
        public static final Type AFTER_LOOKUP = new Type(6);
        private int type;

        protected Type(int n) {
            this.type = n;
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PBStateEvent)) {
                return false;
            }
            return this.type == ((Type)object).type;
        }

        public final int hashCode() {
            return this.type;
        }

        public final int typeId() {
            return this.type;
        }

        public String toString() {
            return this.getClass().getName() + " [type= " + Type.typeAsName(this.type) + "]";
        }

        private static String typeAsName(int n) {
            if (n == 5) {
                return "AFTER_DELETE";
            }
            if (n == 6) {
                return "AFTER_LOOKUP";
            }
            if (n == 7) {
                return "AFTER_INSERT";
            }
            if (n == 4) {
                return "AFTER_UPDATE";
            }
            if (n == 2) {
                return "BEFORE_DELETE";
            }
            if (n == 1) {
                return "BEFORE_INSERT";
            }
            if (n == 3) {
                return "BEFORE_UPDATE";
            }
            throw new OJBRuntimeException("Could not find type with typeId " + n);
        }
    }
}

