/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class BasePrefetcher
implements RelationshipPrefetcher {
    protected static final int IN_LIMIT = BasePrefetcher.getPrefetchInLimit();
    private Logger logger;
    private PersistenceBrokerImpl broker;
    protected ClassDescriptor itemClassDesc;
    protected final int pkLimit;

    private static int getPrefetchInLimit() {
        try {
            PersistenceBrokerConfiguration persistenceBrokerConfiguration = (PersistenceBrokerConfiguration)((Object)PersistenceBrokerFactory.getConfigurator().getConfigurationFor(null));
            return persistenceBrokerConfiguration.getSqlInLimit();
        }
        catch (ConfigurationException configurationException) {
            return 200;
        }
    }

    public BasePrefetcher(PersistenceBrokerImpl persistenceBrokerImpl, Class clazz) {
        this.broker = persistenceBrokerImpl;
        this.itemClassDesc = persistenceBrokerImpl.getDescriptorRepository().getDescriptorFor(clazz);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pkLimit = BasePrefetcher.getPrefetchInLimit() / this.getItemClassDescriptor().getPkFields().length;
    }

    @Override
    public int getLimit() {
        return this.pkLimit;
    }

    protected abstract void associateBatched(Collection var1, Collection var2);

    @Override
    public void prefetchRelationship(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Query[] queryArray = this.buildPrefetchQueries(collection, arrayList);
        for (int i = 0; i < queryArray.length; ++i) {
            Iterator iterator = this.getBroker().getIteratorByQuery(queryArray[i]);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        this.getBroker().getReferenceBroker().performRetrievalTasks();
        this.associateBatched(collection, arrayList);
    }

    protected QueryByCriteria buildPrefetchQuery(Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        return this.buildPrefetchQuery(this.getItemClassDescriptor().getClassOfObject(), collection, fieldDescriptorArray);
    }

    protected Criteria buildPrefetchCriteria(Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        if (fieldDescriptorArray.length == 1) {
            return this.buildPrefetchCriteriaSingleKey(collection, fieldDescriptorArray[0]);
        }
        return this.buildPrefetchCriteriaMultipleKeys(collection, fieldDescriptorArray);
    }

    protected QueryByCriteria buildPrefetchQuery(Class clazz, Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        return QueryFactory.newQuery(clazz, this.buildPrefetchCriteria(collection, fieldDescriptorArray));
    }

    private Criteria buildPrefetchCriteriaSingleKey(Collection collection, FieldDescriptor fieldDescriptor) {
        Criteria criteria = new Criteria();
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Identity identity : collection) {
            arrayList.add(identity.getPrimaryKeyValues()[0]);
        }
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                criteria.addEqualTo(fieldDescriptor.getAttributeName(), arrayList.get(0));
                break;
            }
            default: {
                criteria.addIn(fieldDescriptor.getAttributeName(), arrayList);
            }
        }
        return criteria;
    }

    private Criteria buildPrefetchCriteriaMultipleKeys(Collection collection, FieldDescriptor[] fieldDescriptorArray) {
        Criteria criteria = new Criteria();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Criteria criteria2 = new Criteria();
            Identity identity = (Identity)iterator.next();
            Object[] objectArray = identity.getPrimaryKeyValues();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    criteria2.addIsNull(fieldDescriptorArray[i].getAttributeName());
                    continue;
                }
                criteria2.addEqualTo(fieldDescriptorArray[i].getAttributeName(), objectArray[i]);
            }
            criteria.addOrCriteria(criteria2);
        }
        return criteria;
    }

    protected DescriptorRepository getDescriptorRepository() {
        return this.getBroker().getDescriptorRepository();
    }

    @Override
    public ClassDescriptor getItemClassDescriptor() {
        return this.itemClassDesc;
    }

    protected abstract Query[] buildPrefetchQueries(Collection var1, Collection var2);

    protected PersistenceBrokerImpl getBroker() {
        return this.broker;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

