/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConnectionFactoryAbstractImpl
implements ConnectionFactory {
    private Logger log = LoggerFactory.getLogger(ConnectionFactoryAbstractImpl.class);
    private Map dataSourceCache = new HashMap();

    public abstract Connection checkOutJdbcConnection(JdbcConnectionDescriptor var1) throws LookupException;

    public abstract void releaseJdbcConnection(JdbcConnectionDescriptor var1, Connection var2) throws LookupException;

    @Override
    public void releaseConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor, Connection connection) {
        if (connection == null) {
            return;
        }
        if (jdbcConnectionDescriptor.isDataSource()) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                this.log.error("Closing connection failed", sQLException);
            }
        } else {
            try {
                this.releaseJdbcConnection(jdbcConnectionDescriptor, connection);
            }
            catch (LookupException lookupException) {
                this.log.error("Unexpected exception when return connection " + connection + " to pool using " + jdbcConnectionDescriptor, (Throwable)((Object)lookupException));
            }
        }
    }

    @Override
    public Connection lookupConnection(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection;
        if (jdbcConnectionDescriptor.isDataSource()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("do datasource lookup, name: " + jdbcConnectionDescriptor.getDatasourceName() + ", user: " + jdbcConnectionDescriptor.getUserName());
            }
            connection = this.newConnectionFromDataSource(jdbcConnectionDescriptor);
        } else {
            connection = this.checkOutJdbcConnection(jdbcConnectionDescriptor);
        }
        return connection;
    }

    protected void initializeJdbcConnection(Connection connection, JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        try {
            PlatformFactory.getPlatformFor(jdbcConnectionDescriptor).initializeJdbcConnection(jdbcConnectionDescriptor, connection);
        }
        catch (PlatformException platformException) {
            throw new LookupException("Platform dependent initialization of connection failed", (Throwable)((Object)platformException));
        }
    }

    @Override
    public synchronized void releaseAllResources() {
        this.dataSourceCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection newConnectionFromDataSource(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection = null;
        DataSource dataSource = jdbcConnectionDescriptor.getDataSource();
        if (dataSource == null) {
            dataSource = (DataSource)this.dataSourceCache.get(jdbcConnectionDescriptor.getDatasourceName());
        }
        try {
            if (dataSource == null) {
                Map map = this.dataSourceCache;
                synchronized (map) {
                    InitialContext initialContext = new InitialContext();
                    dataSource = (DataSource)initialContext.lookup(jdbcConnectionDescriptor.getDatasourceName());
                    this.dataSourceCache.put(jdbcConnectionDescriptor.getDatasourceName(), dataSource);
                }
            }
            connection = jdbcConnectionDescriptor.getUserName() == null ? dataSource.getConnection() : dataSource.getConnection(jdbcConnectionDescriptor.getUserName(), jdbcConnectionDescriptor.getPassWord());
        }
        catch (SQLException sQLException) {
            this.log.error("SQLException thrown while trying to get Connection from Datasource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", sQLException);
            throw new LookupException("SQLException thrown while trying to get Connection from Datasource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", sQLException);
        }
        catch (NamingException namingException) {
            this.log.error("Naming Exception while looking up DataSource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", namingException);
            throw new LookupException("Naming Exception while looking up DataSource (" + jdbcConnectionDescriptor.getDatasourceName() + ")", namingException);
        }
        this.initializeJdbcConnection(connection, jdbcConnectionDescriptor);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DataSource: " + connection);
        }
        return connection;
    }

    protected Connection newConnectionFromDriverManager(JdbcConnectionDescriptor jdbcConnectionDescriptor) throws LookupException {
        Connection connection = null;
        String string = jdbcConnectionDescriptor.getDriver();
        String string2 = this.getDbURL(jdbcConnectionDescriptor);
        try {
            ClassHelper.getClass(string, true);
            String string3 = jdbcConnectionDescriptor.getUserName();
            String string4 = jdbcConnectionDescriptor.getPassWord();
            Properties properties = this.getJdbcProperties(jdbcConnectionDescriptor, string3, string4);
            connection = properties.isEmpty() ? (string3 == null ? DriverManager.getConnection(string2) : DriverManager.getConnection(string2, string3, string4)) : DriverManager.getConnection(string2, properties);
        }
        catch (SQLException sQLException) {
            this.log.error("Error getting Connection from DriverManager with url (" + string2 + ") and driver (" + string + ")", sQLException);
            throw new LookupException("Error getting Connection from DriverManager with url (" + string2 + ") and driver (" + string + ")", sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error(classNotFoundException);
            throw new LookupException("A class was not found", classNotFoundException);
        }
        catch (Exception exception) {
            this.log.error("Instantiation of jdbc driver failed", exception);
            throw new LookupException("Instantiation of jdbc driver failed", exception);
        }
        this.initializeJdbcConnection(connection, jdbcConnectionDescriptor);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create new connection using DriverManager: " + connection);
        }
        return connection;
    }

    protected Properties getJdbcProperties(JdbcConnectionDescriptor jdbcConnectionDescriptor, String string, String string2) {
        Properties properties = jdbcConnectionDescriptor.getConnectionPoolDescriptor().getJdbcProperties();
        if (string != null) {
            properties.put("user", string);
            properties.put("password", string2);
        }
        return properties;
    }

    protected Properties getJdbcProperties(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        String string = jdbcConnectionDescriptor.getUserName();
        String string2 = jdbcConnectionDescriptor.getPassWord();
        return this.getJdbcProperties(jdbcConnectionDescriptor, string, string2);
    }

    protected String getDbURL(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        return jdbcConnectionDescriptor.isDataSource() ? jdbcConnectionDescriptor.getDatasourceName() : jdbcConnectionDescriptor.getProtocol() + ":" + jdbcConnectionDescriptor.getSubProtocol() + ":" + jdbcConnectionDescriptor.getDbAlias();
    }

    protected String getJcdDescription(JdbcConnectionDescriptor jdbcConnectionDescriptor) {
        return "Connection for JdbcConnectionDescriptor (" + (jdbcConnectionDescriptor.getDatasourceName() != null ? "datasource: " + jdbcConnectionDescriptor.getDatasourceName() : "db-url: " + this.getDbURL(jdbcConnectionDescriptor) + ", user: " + jdbcConnectionDescriptor.getUserName()) + ")";
    }
}

