/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.SqlHelper;

public class RowReaderDefaultImpl
implements RowReader {
    private static final String OJB_CONCRETE_CLASS_KEY = "ojbTemporaryNoneColumnKey";
    private static final Object[] NO_ARGS = new Object[0];
    private ClassDescriptor m_cld;

    public RowReaderDefaultImpl(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    @Override
    public Object readObjectFrom(Map map) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        return this.buildOrRefreshObject(map, classDescriptor, null);
    }

    @Override
    public void refreshObject(Object object, Map map) {
        ClassDescriptor classDescriptor = this.selectClassDescriptor(map);
        this.buildOrRefreshObject(map, classDescriptor, object);
    }

    protected Object buildOrRefreshObject(Map map, ClassDescriptor classDescriptor, Object object) {
        Method method;
        Object object2 = object;
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getFieldDescriptor(true);
        if (object == null) {
            object2 = ClassHelper.buildNewObjectInstance(classDescriptor);
        }
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            fieldDescriptor.getPersistentField().set(object2, map.get(fieldDescriptor.getColumnName()));
        }
        if (object == null && (method = classDescriptor.getInitializationMethod()) != null) {
            try {
                method.invoke(object2, NO_ARGS);
            }
            catch (Exception exception) {
                throw new PersistenceBrokerException("Unable to invoke initialization method:" + method.getName() + " for class:" + this.m_cld.getClassOfObject(), exception);
            }
        }
        return object2;
    }

    @Override
    public void readObjectArrayFrom(ResultSetAndStatement resultSetAndStatement, Map map) {
        FieldDescriptor[] fieldDescriptorArray;
        if (this.m_cld.getSuperClass() != null) {
            fieldDescriptorArray = this.m_cld.getFieldDescriptorsInHeirarchy();
        } else {
            String string = this.extractOjbConcreteClass(this.m_cld, resultSetAndStatement.m_rs, map);
            if (string != null) {
                ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(string);
                map.put(OJB_CONCRETE_CLASS_KEY, classDescriptor.getClassOfObject());
                fieldDescriptorArray = classDescriptor.getFieldDescriptor(true);
            } else {
                String string2 = SqlHelper.getOjbClassName(resultSetAndStatement.m_rs);
                if (string2 != null) {
                    ClassDescriptor classDescriptor = this.m_cld.getRepository().getDescriptorFor(string2);
                    map.put(OJB_CONCRETE_CLASS_KEY, classDescriptor.getClassOfObject());
                    fieldDescriptorArray = classDescriptor.getFieldDescriptor(true);
                } else {
                    fieldDescriptorArray = this.m_cld.getFieldDescriptor(true);
                }
            }
        }
        this.readValuesFrom(resultSetAndStatement, map, fieldDescriptorArray);
    }

    @Override
    public void readPkValuesFrom(ResultSetAndStatement resultSetAndStatement, Map map) {
        String string = SqlHelper.getOjbClassName(resultSetAndStatement.m_rs);
        ClassDescriptor classDescriptor = string != null ? this.m_cld.getRepository().getDescriptorFor(string) : this.m_cld;
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        this.readValuesFrom(resultSetAndStatement, map, fieldDescriptorArray);
    }

    protected void readValuesFrom(ResultSetAndStatement resultSetAndStatement, Map map, FieldDescriptor[] fieldDescriptorArray) {
        int n = fieldDescriptorArray.length;
        FieldDescriptor fieldDescriptor = null;
        try {
            for (int i = 0; i < n; ++i) {
                fieldDescriptor = fieldDescriptorArray[i];
                if (map.containsKey(fieldDescriptor.getColumnName())) continue;
                int n2 = resultSetAndStatement.m_sql.getColumnIndex(fieldDescriptor);
                Object object = fieldDescriptor.getJdbcType().getObjectFromColumn(resultSetAndStatement.m_rs, null, fieldDescriptor.getColumnName(), n2);
                map.put(fieldDescriptor.getColumnName(), fieldDescriptor.getFieldConversion().sqlToJava(object));
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException("Error reading class '" + (fieldDescriptor != null ? fieldDescriptor.getClassDescriptor().getClassNameOfObject() : this.m_cld.getClassNameOfObject()) + "' from result set, current read field was '" + (fieldDescriptor != null ? fieldDescriptor.getPersistentField().getName() + "'" : null), sQLException);
        }
    }

    protected String extractOjbConcreteClass(ClassDescriptor classDescriptor, ResultSet resultSet, Map map) {
        FieldDescriptor fieldDescriptor = this.m_cld.getOjbConcreteClassField();
        if (fieldDescriptor == null) {
            return null;
        }
        try {
            Object object = fieldDescriptor.getJdbcType().getObjectFromColumn(resultSet, fieldDescriptor.getColumnName());
            String string = (String)fieldDescriptor.getFieldConversion().sqlToJava(object);
            String string2 = string = string != null ? string.trim() : null;
            if (string == null || string.length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field for class " + classDescriptor.getClassNameOfObject() + " returned null or 0-length string");
            }
            map.put(fieldDescriptor.getColumnName(), string);
            return string;
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException("Unexpected error while try to read 'ojbConcretClass' field from result set using column name " + fieldDescriptor.getColumnName() + " main class" + " was " + this.m_cld.getClassNameOfObject(), sQLException);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map map) throws PersistenceBrokerException {
        ClassDescriptor classDescriptor = this.m_cld;
        Class clazz = (Class)map.get(OJB_CONCRETE_CLASS_KEY);
        if (clazz != null && (classDescriptor = this.m_cld.getRepository().getDescriptorFor(clazz)) == null) {
            throw new PersistenceBrokerException("Can't find class-descriptor for ojbConcreteClass '" + clazz + "', the main class was " + this.m_cld.getClassNameOfObject());
        }
        return classDescriptor;
    }

    @Override
    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.m_cld = classDescriptor;
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }
}

