/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class StringList2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";

    @Override
    public Object javaToSql(Object object) throws ConversionException {
        if (object == null) {
            return NULLVALUE;
        }
        try {
            List list = (List)object;
            if (list.isEmpty()) {
                return NULLVALUE;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                string = StringUtils.replace((String)string, (String)"#", (String)"##");
                if (i > 0) {
                    stringBuffer.append("#");
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        catch (ClassCastException classCastException) {
            throw new ConversionException("Object is not a List of String it is a" + object.getClass().getName());
        }
    }

    @Override
    public Object sqlToJava(Object object) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (object.toString().equals(NULLVALUE)) {
            return null;
        }
        if (object.toString().equals(EMPTYCOLLEC)) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(object.toString());
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (stringBuffer.charAt(i) != '#') {
                stringBuffer2.append(stringBuffer.charAt(i));
                continue;
            }
            if (stringBuffer.charAt(i + 1) != '#') {
                arrayList.add(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer();
                continue;
            }
            stringBuffer2.append('#');
            ++i;
        }
        arrayList.add(stringBuffer2.toString());
        return arrayList;
    }
}

