/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.ddlutils.model.Database;
import org.apache.ojb.broker.ant.Command;
import org.apache.ojb.broker.ant.DdlUtilsDataHandling;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataToDatabaseCommand
extends Command {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();
    private Boolean _useBatchMode;
    private Integer _batchSize;

    public void addConfiguredFileset(FileSet fileSet) {
        this._fileSets.add(fileSet);
    }

    public void setDataFile(File file) {
        this._singleDataFile = file;
    }

    public void setBatchSize(int n) {
        this._batchSize = new Integer(n);
    }

    public void setUseBatchMode(boolean bl) {
        this._useBatchMode = bl;
    }

    @Override
    public void execute(Task task, Database database, DescriptorRepository descriptorRepository) throws BuildException {
        try {
            DdlUtilsDataHandling ddlUtilsDataHandling = new DdlUtilsDataHandling();
            ddlUtilsDataHandling.setModel(database, descriptorRepository);
            ddlUtilsDataHandling.setPlatform(this.getPlatform());
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, ddlUtilsDataHandling, this._singleDataFile);
            } else {
                for (FileSet fileSet : this._fileSets) {
                    File file = fileSet.getDir(task.getProject());
                    DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] stringArray = directoryScanner.getIncludedFiles();
                    for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                        this.readSingleDataFile(task, ddlUtilsDataHandling, new File(file, stringArray[i]));
                    }
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException((Throwable)exception);
        }
    }

    private void readSingleDataFile(Task task, DdlUtilsDataHandling ddlUtilsDataHandling, File file) {
        if (!file.exists()) {
            task.log("Could not find data file " + file.getAbsolutePath(), 0);
        } else if (!file.isFile()) {
            task.log("Path " + file.getAbsolutePath() + " does not denote a data file", 0);
        } else if (!file.canRead()) {
            task.log("Could not read data file " + file.getAbsolutePath(), 0);
        } else {
            int n = 1;
            if (this._useBatchMode != null && this._useBatchMode.booleanValue() && this._batchSize != null) {
                n = this._batchSize;
            }
            try {
                ddlUtilsDataHandling.insertData(new FileReader(file), n);
                task.log("Read data file " + file.getAbsolutePath(), 2);
            }
            catch (Exception exception) {
                if (this.isFailOnError()) {
                    throw new BuildException("Could not read data file " + file.getAbsolutePath(), (Throwable)exception);
                }
                task.log("Could not read data file " + file.getAbsolutePath(), 0);
            }
        }
    }
}

