/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.AbstractMetaCache;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheJCSImpl;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ObjectCacheJCSPerClassImpl
extends AbstractMetaCache {
    private static Map cachesByClass = new HashMap();

    public ObjectCacheJCSPerClassImpl(PersistenceBroker persistenceBroker, Properties properties) {
    }

    @Override
    public ObjectCache getCache(Identity identity, Object object, int n) {
        if (identity.getObjectsRealClass() == null) {
            LoggerFactory.getDefaultLogger().info("[" + this.getClass() + "] Can't get JCS cache, real class was 'null' for Identity: " + identity);
            return null;
        }
        return this.getCachePerClass(identity.getObjectsRealClass(), n);
    }

    @Override
    public void clear() {
        Iterator iterator = cachesByClass.values().iterator();
        while (iterator.hasNext()) {
            ObjectCache objectCache = (ObjectCache)iterator.next();
            if (objectCache != null) {
                objectCache.clear();
                continue;
            }
            iterator.remove();
        }
    }

    private ObjectCache getCachePerClass(Class clazz, int n) {
        ObjectCache objectCache = (ObjectCache)cachesByClass.get(clazz.getName());
        if (objectCache == null && n == 1) {
            objectCache = new ObjectCacheJCSImpl(clazz.getName());
            cachesByClass.put(clazz.getName(), objectCache);
        }
        return objectCache;
    }
}

