/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerInternal;

public class PersistenceBrokerThreadMapping {
    private static Collection loadedHMs = new HashSet();
    private static final Object lock = new Object();
    private static ThreadLocal currentBrokerMap = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentPersistenceBroker(PBKey pBKey, PersistenceBrokerInternal persistenceBrokerInternal) throws PBFactoryException {
        HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>> hashMap = (HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>>)currentBrokerMap.get();
        WeakHashMap<PersistenceBrokerInternal, Object> weakHashMap = null;
        if (hashMap == null) {
            hashMap = new HashMap<PBKey, WeakHashMap<PersistenceBrokerInternal, Object>>();
            currentBrokerMap.set(hashMap);
            Object object = lock;
            synchronized (object) {
                loadedHMs.add(hashMap);
            }
        } else {
            weakHashMap = (WeakHashMap<PersistenceBrokerInternal, Object>)hashMap.get(pBKey);
        }
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<PersistenceBrokerInternal, Object>();
            hashMap.put(pBKey, weakHashMap);
        }
        weakHashMap.put(persistenceBrokerInternal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsetCurrentPersistenceBroker(PBKey pBKey, PersistenceBrokerInternal persistenceBrokerInternal) throws PBFactoryException {
        HashMap hashMap = (HashMap)currentBrokerMap.get();
        WeakHashMap weakHashMap = null;
        if (hashMap != null) {
            weakHashMap = (WeakHashMap)hashMap.get(pBKey);
            if (weakHashMap != null) {
                weakHashMap.remove(persistenceBrokerInternal);
                if (weakHashMap.isEmpty()) {
                    hashMap.remove(pBKey);
                }
            }
            if (hashMap.isEmpty()) {
                currentBrokerMap.set(null);
                Object object = lock;
                synchronized (object) {
                    loadedHMs.remove(hashMap);
                }
            }
        }
    }

    public static PersistenceBrokerInternal currentPersistenceBroker(PBKey pBKey) throws PBFactoryException, PersistenceBrokerException {
        HashMap hashMap = (HashMap)currentBrokerMap.get();
        PersistenceBrokerInternal persistenceBrokerInternal = null;
        if (hashMap == null) {
            return null;
        }
        WeakHashMap weakHashMap = (WeakHashMap)hashMap.get(pBKey);
        if (weakHashMap == null) {
            return null;
        }
        Iterator iterator = weakHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            PersistenceBrokerInternal persistenceBrokerInternal2 = (PersistenceBrokerInternal)iterator.next();
            if (persistenceBrokerInternal2 == null || persistenceBrokerInternal2.isClosed()) {
                iterator.remove();
                continue;
            }
            persistenceBrokerInternal = persistenceBrokerInternal2;
            if (!persistenceBrokerInternal2.isInTransaction()) continue;
            break;
        }
        return persistenceBrokerInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = lock;
        synchronized (object) {
            Iterator iterator = loadedHMs.iterator();
            while (iterator.hasNext()) {
                ((HashMap)iterator.next()).clear();
            }
            loadedHMs.clear();
            loadedHMs = null;
        }
        currentBrokerMap = null;
    }
}

