/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.ojb.broker.core.proxy.AbstractProxyFactory;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.IndirectionHandlerJDK;
import org.apache.ojb.broker.core.proxy.IndirectionHandlerJDKImpl;
import org.apache.ojb.broker.core.proxy.OJBProxy;

public class ProxyFactoryJDKImpl
extends AbstractProxyFactory {
    private HashMap foundInterfaces = new HashMap();

    @Override
    public Class getDefaultIndirectionHandlerClass() {
        return IndirectionHandlerJDKImpl.class;
    }

    @Override
    public Class getIndirectionHandlerBaseClass() {
        return IndirectionHandlerJDK.class;
    }

    @Override
    public OJBProxy createProxy(Class clazz, IndirectionHandler indirectionHandler) throws Exception {
        Class clazz2 = this.getDynamicProxyClass(clazz);
        Constructor constructor = clazz2.getDeclaredConstructor(InvocationHandler.class);
        return (OJBProxy)constructor.newInstance(indirectionHandler);
    }

    @Override
    public IndirectionHandler getDynamicIndirectionHandler(Object object) {
        return (IndirectionHandler)((Object)Proxy.getInvocationHandler(object));
    }

    @Override
    public boolean isNormalOjbProxy(Object object) {
        return super.isNormalOjbProxy(object) && object instanceof Proxy && Proxy.isProxyClass(object.getClass());
    }

    private Class getDynamicProxyClass(Class clazz) {
        Class[] classArray;
        if (this.foundInterfaces.containsKey(clazz)) {
            classArray = (Class[])this.foundInterfaces.get(clazz);
        } else {
            classArray = this.getInterfaces(clazz);
            this.foundInterfaces.put(clazz, classArray);
        }
        Class<?> clazz2 = Proxy.getProxyClass(clazz.getClassLoader(), classArray);
        return clazz2;
    }

    private Class[] getInterfaces(Class clazz) {
        Object object;
        Class clazz2 = clazz;
        Class[] classArray = clazz.getInterfaces();
        if (clazz.isInterface()) {
            object = new Class[classArray.length + 1];
            object[0] = clazz;
            System.arraycopy(classArray, 0, object, 1, classArray.length);
            classArray = object;
        }
        while ((clazz2 = clazz2.getSuperclass()) != null) {
            object = clazz2.getInterfaces();
            Class[] classArray2 = new Class[classArray.length + ((Class[])object).length];
            System.arraycopy(classArray, 0, classArray2, 0, classArray.length);
            System.arraycopy(object, 0, classArray2, classArray.length, ((Object)object).length);
            classArray = classArray2;
        }
        object = new HashMap();
        for (int i = 0; i < classArray.length; ++i) {
            ((HashMap)object).put(classArray[i].getName(), classArray[i]);
        }
        ((HashMap)object).put(OJBProxy.class.getName(), OJBProxy.class);
        classArray = ((HashMap)object).values().toArray(new Class[((HashMap)object).size()]);
        return classArray;
    }

    @Override
    public boolean interfaceRequiredForProxyGeneration() {
        return true;
    }
}

