/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class LockHelper {
    LockHelper() {
    }

    public static int getIsolationLevelFor(String string) {
        if (string == null || StringUtils.isEmpty((String)string)) {
            LoggerFactory.getDefaultLogger().debug("[LockHelper] Specified isolation level string is 'null', using the default isolation level");
            return 2;
        }
        if (string.equalsIgnoreCase("read-uncommitted")) {
            return 2;
        }
        if (string.equalsIgnoreCase("read-committed")) {
            return 3;
        }
        if (string.equalsIgnoreCase("repeatable-read")) {
            return 5;
        }
        if (string.equalsIgnoreCase("serializable")) {
            return 7;
        }
        if (string.equalsIgnoreCase("optimistic")) {
            return 4;
        }
        if (string.equalsIgnoreCase("none")) {
            return -1;
        }
        LoggerFactory.getDefaultLogger().warn("[LockHelper] Unknown isolation-level '" + string + "', using default isolation level");
        return 2;
    }
}

