/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.locking;

import org.apache.ojb.broker.locking.LockIsolation;

class LockIsolationManager {
    private LockIsolation readUncommitedStrategy = new ReadUncommittedIsolation();
    private LockIsolation readCommitedStrategy = new ReadCommittedIsolation();
    private LockIsolation readRepeatableStrategy = new RepeatableReadIsolation();
    private LockIsolation serializableStrategy = new SerializableIsolation();

    LockIsolationManager() {
    }

    public LockIsolation getStrategyFor(int n) {
        switch (n) {
            case 2: {
                return this.readUncommitedStrategy;
            }
            case 3: {
                return this.readCommitedStrategy;
            }
            case 5: {
                return this.readRepeatableStrategy;
            }
            case 7: {
                return this.serializableStrategy;
            }
        }
        return this.readUncommitedStrategy;
    }

    class SerializableIsolation
    extends LockIsolation {
        SerializableIsolation() {
        }

        @Override
        public int getIsolationLevel() {
            return 7;
        }

        @Override
        public String getIsolationLevelAsString() {
            return "serializable";
        }

        @Override
        public boolean allowMultipleRead() {
            return false;
        }

        @Override
        public boolean allowWriteWhenRead() {
            return false;
        }

        @Override
        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class RepeatableReadIsolation
    extends LockIsolation {
        @Override
        public int getIsolationLevel() {
            return 5;
        }

        @Override
        public String getIsolationLevelAsString() {
            return "repeatable-read";
        }

        @Override
        public boolean allowMultipleRead() {
            return true;
        }

        @Override
        public boolean allowWriteWhenRead() {
            return false;
        }

        @Override
        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class ReadCommittedIsolation
    extends LockIsolation {
        ReadCommittedIsolation() {
        }

        @Override
        public int getIsolationLevel() {
            return 3;
        }

        @Override
        public String getIsolationLevelAsString() {
            return "read-committed";
        }

        @Override
        public boolean allowMultipleRead() {
            return true;
        }

        @Override
        public boolean allowWriteWhenRead() {
            return true;
        }

        @Override
        public boolean allowReadWhenWrite() {
            return false;
        }
    }

    class ReadUncommittedIsolation
    extends LockIsolation {
        ReadUncommittedIsolation() {
        }

        @Override
        public int getIsolationLevel() {
            return 2;
        }

        @Override
        public String getIsolationLevelAsString() {
            return "read-uncommitted";
        }

        @Override
        public boolean allowMultipleRead() {
            return true;
        }

        @Override
        public boolean allowWriteWhenRead() {
            return true;
        }

        @Override
        public boolean allowReadWhenWrite() {
            return true;
        }
    }
}

