/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.platforms.Oracle9iLobHandler;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformOracleImpl;
import org.apache.ojb.broker.util.ClassHelper;

public class PlatformWLOracle9iImpl
extends PlatformOracleImpl {
    protected static final int ROW_PREFETCH_SIZE = 100;
    protected static final int STATEMENTS_PER_BATCH = 20;
    protected static Map m_batchStatementsInProgress = Collections.synchronizedMap(new WeakHashMap(20));
    protected static final Class[] PARAM_TYPE_INTEGER = new Class[]{Integer.TYPE};
    protected static final Class[] PARAM_TYPE_BOOLEAN = new Class[]{Boolean.TYPE};
    protected static final Class[] PARAM_TYPE_STRING = new Class[]{String.class};
    protected static final Object[] PARAM_ROW_PREFETCH_SIZE = new Object[]{new Integer(100)};
    protected static final Object[] PARAM_STATEMENT_BATCH_SIZE = new Object[]{new Integer(20)};
    protected static final Object[] PARAM_BOOLEAN_TRUE = new Object[]{Boolean.TRUE};
    protected static final JdbcType BASE_CLOB = JdbcTypesHelper.getJdbcTypeByName("clob");
    protected static final JdbcType BASE_BLOB = JdbcTypesHelper.getJdbcTypeByName("blob");

    @Override
    public void afterStatementCreate(Statement statement) throws PlatformException {
        boolean bl;
        super.afterStatementCreate(statement);
        Method method = ClassHelper.getMethod(statement, "setRowPrefetch", PARAM_TYPE_INTEGER);
        boolean bl2 = bl = method != null;
        if (bl) {
            try {
                method.invoke((Object)statement, PARAM_ROW_PREFETCH_SIZE);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        }
    }

    @Override
    public void beforeBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl;
        Method method = ClassHelper.getMethod(preparedStatement, "setExecuteBatch", PARAM_TYPE_INTEGER);
        Method method2 = ClassHelper.getMethod(preparedStatement, "sendBatch", null);
        boolean bl2 = bl = method != null && method2 != null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, PARAM_STATEMENT_BATCH_SIZE);
                m_batchStatementsInProgress.put(preparedStatement, method2);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            super.beforeBatch(preparedStatement);
        }
    }

    @Override
    public void addBatch(PreparedStatement preparedStatement) throws PlatformException {
        boolean bl = m_batchStatementsInProgress.containsKey(preparedStatement);
        if (bl) {
            try {
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                throw new PlatformException(sQLException.getLocalizedMessage(), sQLException);
            }
        } else {
            super.addBatch(preparedStatement);
        }
    }

    @Override
    public int[] executeBatch(PreparedStatement preparedStatement) throws PlatformException {
        Method method = (Method)m_batchStatementsInProgress.remove(preparedStatement);
        boolean bl = method != null;
        int[] nArray = null;
        if (bl) {
            try {
                method.invoke((Object)preparedStatement, null);
            }
            catch (Exception exception) {
                throw new PlatformException(exception.getLocalizedMessage(), exception);
            }
        } else {
            nArray = super.executeBatch(preparedStatement);
        }
        return nArray;
    }

    @Override
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        if (n2 == 2005) {
            try {
                object2 = ClassHelper.getClass("oracle.sql.CLOB", false);
                method2 = ClassHelper.getMethod(preparedStatement, "setCLOB", new Class[]{Integer.TYPE, object2});
                method3 = ClassHelper.getMethod(preparedStatement.getConnection(), "getVendorConnection", new Class[0]);
                bl2 = method2 != null && method3 != null;
            }
            catch (Exception exception) {}
        } else if (n2 == 2004) {
            try {
                object2 = ClassHelper.getClass("oracle.sql.BLOB", false);
                method = ClassHelper.getMethod(preparedStatement, "setBLOB", new Class[]{Integer.TYPE, object2});
                method3 = ClassHelper.getMethod(preparedStatement.getConnection(), "getVendorConnection", new Class[0]);
                bl = method != null && method3 != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n2 == -3 || n2 == -4) && object instanceof byte[]) {
            object2 = (byte[])object;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
            super.changePreparedStatementResultSetType(preparedStatement);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, ((Object)object2).length);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (n2 == -5 && object instanceof Integer) {
            preparedStatement.setLong(n, ((Integer)object).intValue());
        } else if (n2 == 4 && object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (n2 == 2005 && bl2 && object instanceof String) {
            try {
                object2 = (Connection)method3.invoke((Object)preparedStatement.getConnection(), new Object[0]);
                Object object3 = Oracle9iLobHandler.createCLOBFromString((Connection)object2, (String)object);
                method2.invoke((Object)preparedStatement, new Integer(n), object3);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else if (n2 == 2004 && bl && object instanceof byte[]) {
            try {
                object2 = (Connection)method3.invoke((Object)preparedStatement.getConnection(), new Object[0]);
                Object object4 = Oracle9iLobHandler.createBLOBFromByteArray((Connection)object2, (byte[])object);
                method.invoke((Object)preparedStatement, new Integer(n), object4);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getLocalizedMessage());
            }
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }
}

