/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.collections;

import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.ManageableVector;

public class RemovalAwareCollection
extends ManageableVector
implements IRemovalAwareCollection {
    private Vector allObjectsToBeRemoved = new Vector();

    @Override
    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.allObjectsToBeRemoved.removeAll(this);
        for (Object e : this.allObjectsToBeRemoved) {
            ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(e.getClass());
            if (!persistenceBroker.serviceBrokerHelper().assertValidPkForDelete(classDescriptor, e)) continue;
            persistenceBroker.delete(e);
        }
        this.allObjectsToBeRemoved.clear();
    }

    @Override
    public Object remove(int n) {
        Object e = super.remove(n);
        this.registerForDeletion(e);
        return e;
    }

    protected void registerForDeletion(Object object) {
        if (!this.allObjectsToBeRemoved.contains(object)) {
            this.allObjectsToBeRemoved.add(object);
        }
    }

    @Override
    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.registerForDeletion(object);
        return bl;
    }

    @Override
    public synchronized void clear() {
        this.removeAllElements();
    }

    @Override
    public synchronized void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.removeAllElements();
    }

    @Override
    public synchronized void removeElementAt(int n) {
        Object e = this.get(n);
        this.registerForDeletion(e);
        super.removeElementAt(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.registerForDeletion(this.get(i));
        }
        super.removeRange(n, n2);
    }
}

