/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.configuration.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConfigurationAbstractImpl
implements Configuration {
    private Logger logger = LoggerFactory.getBootLogger();
    protected String filename;
    protected Properties properties;
    private String[] trueValues = new String[]{"true", "yes", "1"};
    private String[] falseValues = new String[]{"false", "no", "0"};

    public ConfigurationAbstractImpl() {
        this.load();
    }

    @Override
    public String getString(String string, String string2) {
        String string3 = this.properties.getProperty(string);
        if (string3 == null) {
            if (string2 == null) {
                this.logger.info("No value for key '" + string + "'");
            } else {
                this.logger.debug("No value for key \"" + string + "\", using default \"" + string2 + "\".");
                this.properties.put(string, string2);
            }
            string3 = string2;
        }
        return string3;
    }

    @Override
    public String[] getStrings(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getString(string, string2), string3);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    @Override
    public String[] getStrings(String string, String string2) {
        return this.getStrings(string, string2, ";");
    }

    @Override
    public int getInteger(String string, int n) {
        int n2;
        try {
            String string2 = this.properties.getProperty(string);
            if (string2 == null) {
                this.properties.put(string, String.valueOf(n));
                this.logger.debug("No value for key \"" + string + "\", using default " + n + ".");
                return n;
            }
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Object object = this.properties.put(string, String.valueOf(n));
            this.logger.warn("Value \"" + object + "\" is illegal for key \"" + string + "\" (should be an integer, using default value " + n + ")");
            n2 = n;
        }
        return n2;
    }

    public long getLong(String string, long l) {
        long l2;
        try {
            String string2 = this.properties.getProperty(string);
            if (string2 == null) {
                this.properties.put(string, String.valueOf(l));
                this.logger.debug("No value for key \"" + string + "\", using default " + l + ".");
                return l;
            }
            l2 = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Object object = this.properties.put(string, String.valueOf(l));
            this.logger.warn("Value \"" + object + "\" is illegal for key \"" + string + "\" (should be an integer, using default value " + l + ")");
            l2 = l;
        }
        return l2;
    }

    public byte getByte(String string, byte by) {
        byte by2;
        try {
            String string2 = this.properties.getProperty(string);
            if (string2 == null) {
                this.properties.put(string, String.valueOf(by));
                this.logger.debug("No value for key \"" + string + "\", using default " + by + ".");
                return by;
            }
            by2 = Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Object object = this.properties.put(string, String.valueOf(by));
            this.logger.warn("Value \"" + object + "\" is illegal for key \"" + string + "\" (should be an integer, using default value " + by + ")");
            by2 = by;
        }
        return by2;
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        int n;
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            this.logger.debug("No value for key \"" + string + "\", using default " + bl + ".");
            this.properties.put(string, String.valueOf(bl));
            return bl;
        }
        for (n = 0; n < this.trueValues.length; ++n) {
            if (!string2.equalsIgnoreCase(this.trueValues[n])) continue;
            return true;
        }
        for (n = 0; n < this.falseValues.length; ++n) {
            if (!string2.equalsIgnoreCase(this.falseValues[n])) continue;
            return false;
        }
        this.logger.warn("Value \"" + string2 + "\" is illegal for key \"" + string + "\" (should be a boolean, using default value " + bl + ")");
        return bl;
    }

    @Override
    public Class getClass(String string, Class clazz, Class[] classArray) {
        String string2 = this.properties.getProperty(string);
        if (string2 == null) {
            if (clazz == null) {
                this.logger.info("No value for key '" + string + "'");
                return null;
            }
            string2 = clazz.getName();
            this.properties.put(string, string2);
            this.logger.debug("No value for key \"" + string + "\", using default " + string2 + ".");
            return clazz;
        }
        Class clazz2 = null;
        try {
            clazz2 = ClassHelper.getClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz2 = clazz;
            this.logger.warn("Value \"" + string2 + "\" is illegal for key \"" + string + "\" (should be a class, using default value " + clazz + ")", classNotFoundException);
        }
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz3 = classArray[i];
            if (clazz3.isAssignableFrom(clazz2)) continue;
            String string3 = clazz3.isInterface() ? "implement the interface " : "extend the class ";
            this.logger.error("The specified class \"" + string2 + "\" does not " + string3 + classArray[i].getName() + ", which is a requirement for the key \"" + string + "\". Using default class " + clazz);
            clazz2 = clazz;
        }
        return clazz2;
    }

    @Override
    public Class getClass(String string, Class clazz, Class clazz2) {
        return this.getClass(string, clazz, new Class[]{clazz2});
    }

    @Override
    public Class getClass(String string, Class clazz) {
        return this.getClass(string, clazz, new Class[0]);
    }

    protected void load() {
        this.properties = new Properties();
        String string = this.getFilename();
        try {
            URL uRL = ClassHelper.getResource(string);
            if (uRL == null) {
                uRL = new File(string).toURL();
            }
            this.logger.info("Loading OJB's properties: " + uRL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string == null || string.length() == 0) {
                this.logger.info("Starting OJB without a properties file. OJB is using default settings instead.");
            } else {
                this.logger.warn("Could not load properties file '" + string + "'. Using default settings!", fileNotFoundException);
            }
        }
        catch (Exception exception) {
            throw new MetadataException("An error happend while loading the properties file '" + string + "'", exception);
        }
    }

    private String getFilename() {
        if (this.filename == null) {
            this.filename = this.getClass().getName() + ".properties";
        }
        return this.filename;
    }

    protected void setFilename(String string) {
        this.filename = string;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

