/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.util.collections.ManageableArrayList;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.Configurator;
import org.apache.ojb.broker.util.factory.ConfigurableFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.DatabaseImpl;
import org.apache.ojb.odmg.ImplementationExt;
import org.apache.ojb.odmg.OJBTxManager;
import org.apache.ojb.odmg.TransactionExt;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockManagerFactory;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DBag;
import org.odmg.DList;
import org.odmg.DMap;
import org.odmg.DSet;
import org.odmg.Database;
import org.odmg.DatabaseClosedException;
import org.odmg.ODMGRuntimeException;
import org.odmg.Transaction;

public class ImplementationImpl
implements ImplementationExt {
    private Logger log = LoggerFactory.getLogger(ImplementationImpl.class);
    private DatabaseImpl currentDatabase;
    private Configurator configurator;
    private OJBTxManager ojbTxManager = TxManagerFactory.instance();
    private LockManager lockManager = LockManagerFactory.getLockManager();
    private Class oqlCollectionClass;
    private boolean impliciteWriteLocks;
    private boolean implicitLocking;
    private boolean implicitLockingBackward;
    private boolean ordering;

    protected ImplementationImpl() {
        this.setConfigurator(PersistenceBrokerFactory.getConfigurator());
        Configuration configuration = this.getConfigurator().getConfigurationFor(null);
        this.oqlCollectionClass = configuration.getClass("OqlCollectionClass", ManageableArrayList.class);
        this.impliciteWriteLocks = configuration.getString("LockAssociations", "WRITE").equalsIgnoreCase("WRITE");
        this.implicitLocking = configuration.getBoolean("ImplicitLocking", true);
        this.ordering = configuration.getBoolean("Ordering", true);
        this.implicitLockingBackward = configuration.getBoolean("ImplicitLockingBackward", false);
        if (this.log.isEnabledFor(2)) {
            this.log.info("Settings: " + this.toString());
        }
    }

    public OJBTxManager getTxManager() {
        return this.ojbTxManager;
    }

    protected LockManager getLockManager() {
        return this.lockManager;
    }

    protected synchronized void setCurrentDatabase(DatabaseImpl databaseImpl) {
        this.currentDatabase = databaseImpl;
    }

    protected synchronized DatabaseImpl getCurrentDatabase() {
        return this.currentDatabase;
    }

    public PBKey getCurrentPBKey() {
        return this.currentDatabase.getPBKey();
    }

    public Configurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public Transaction newTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        TransactionImpl transactionImpl = new TransactionImpl(this);
        try {
            this.getConfigurator().configure(transactionImpl);
        }
        catch (ConfigurationException configurationException) {
            throw new ODMGRuntimeException("Error in configuration of TransactionImpl instance: " + configurationException.getMessage());
        }
        return transactionImpl;
    }

    @Override
    public Transaction currentTransaction() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, must have a DB in order to create a transaction");
        }
        return this.ojbTxManager.getTransaction();
    }

    public boolean hasOpenTransaction() {
        TransactionImpl transactionImpl = this.ojbTxManager.getTransaction();
        return transactionImpl != null && transactionImpl.isOpen();
    }

    @Override
    public Database newDatabase() {
        return new DatabaseImpl(this);
    }

    @Override
    public EnhancedOQLQuery newOQLQuery() {
        if (this.getCurrentDatabase() == null || !this.getCurrentDatabase().isOpen()) {
            throw new DatabaseClosedException("Database is not open");
        }
        return new OQLQueryImpl(this);
    }

    @Override
    public DList newDList() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DList with a null database.");
        }
        return (DList)DListFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    @Override
    public DBag newDBag() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DBag with a null database.");
        }
        return (DBag)DBagFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    @Override
    public DSet newDSet() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DSet with a null database.");
        }
        return (DSet)DSetFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    @Override
    public DArray newDArray() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DArray with a null database.");
        }
        return (DArray)DArrayFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    @Override
    public DMap newDMap() {
        if (this.getCurrentDatabase() == null) {
            throw new DatabaseClosedException("Database is NULL, cannot create a DMap with a null database.");
        }
        return (DMap)DMapFactory.singleton.createCollectionOrMap(this.getCurrentPBKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getObjectId(Object object) {
        Identity identity = null;
        try (PersistenceBroker persistenceBroker = null;){
            if (this.getCurrentDatabase() != null) {
                persistenceBroker = PersistenceBrokerFactory.createPersistenceBroker(this.getCurrentDatabase().getPBKey());
            } else {
                this.log.warn("Can't find open database, try to use the default configuration");
                persistenceBroker = PersistenceBrokerFactory.defaultPersistenceBroker();
            }
            identity = persistenceBroker.serviceIdentity().buildIdentity(object);
        }
        return new String(SerializationUtils.serialize((Serializable)identity));
    }

    @Override
    public Database getDatabase(Object object) {
        return this.getCurrentDatabase();
    }

    protected synchronized void registerOpenDatabase(DatabaseImpl databaseImpl) {
        DatabaseImpl databaseImpl2 = this.getCurrentDatabase();
        if (databaseImpl2 != null) {
            try {
                if (databaseImpl2.isOpen()) {
                    this.log.warn("## There is still an opened database, close old one ##");
                    databaseImpl2.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Set current database " + databaseImpl + " PBKey was " + databaseImpl.getPBKey());
        }
        this.setCurrentDatabase(databaseImpl);
    }

    @Override
    public void setImplicitLocking(boolean bl) {
        if (this.implicitLockingBackward) {
            ((TransactionExt)this.currentTransaction()).setImplicitLocking(bl);
        } else {
            this.implicitLocking = bl;
        }
    }

    @Override
    public boolean isImplicitLocking() {
        return this.implicitLocking;
    }

    @Override
    public Class getOqlCollectionClass() {
        return this.oqlCollectionClass;
    }

    @Override
    public void setOqlCollectionClass(Class clazz) {
        this.oqlCollectionClass = clazz;
    }

    @Override
    public void setImpliciteWriteLocks(boolean bl) {
        this.impliciteWriteLocks = bl;
    }

    @Override
    public boolean isImpliciteWriteLocks() {
        return this.impliciteWriteLocks;
    }

    @Override
    public boolean isOrdering() {
        return this.ordering;
    }

    @Override
    public void setOrdering(boolean bl) {
        this.ordering = bl;
    }

    public void setImplicitLockingBackward(boolean bl) {
        this.implicitLockingBackward = bl;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("implicitLocking", this.isImplicitLocking()).append("implicitWriteLocks", this.isImpliciteWriteLocks()).append("ordering", this.isOrdering()).append("oqlCollectionClass", (Object)this.getOqlCollectionClass()).append("txManager", (Object)this.getTxManager()).append("lockManager", (Object)this.getLockManager()).toString();
    }

    static final class DMapFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DMapFactory();

        DMapFactory() {
        }

        @Override
        protected String getConfigurationKey() {
            return "DMapClass";
        }
    }

    static final class DSetFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DSetFactory();

        DSetFactory() {
        }

        @Override
        protected String getConfigurationKey() {
            return "DSetClass";
        }
    }

    static final class DBagFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DBagFactory();

        DBagFactory() {
        }

        @Override
        protected String getConfigurationKey() {
            return "DBagClass";
        }
    }

    static final class DArrayFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DArrayFactory();

        DArrayFactory() {
        }

        @Override
        protected String getConfigurationKey() {
            return "DArrayClass";
        }
    }

    static final class DListFactory
    extends BaseFactory {
        static final BaseFactory singleton = new DListFactory();

        DListFactory() {
        }

        @Override
        protected String getConfigurationKey() {
            return "DListClass";
        }
    }

    static abstract class BaseFactory
    extends ConfigurableFactory {
        BaseFactory() {
        }

        Object createCollectionOrMap() {
            return this.createNewInstance();
        }

        Object createCollectionOrMap(PBKey pBKey) {
            return this.createNewInstance(PBKey.class, pBKey);
        }
    }
}

