/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.LockManager;

public class LockManagerOdmgImpl
implements LockManager {
    private org.apache.ojb.broker.locking.LockManager lm;

    public LockManagerOdmgImpl(org.apache.ojb.broker.locking.LockManager lockManager) {
        this.lm = lockManager;
    }

    private boolean ignore(int n) {
        return n == 4 || n == -1;
    }

    @Override
    public boolean readLock(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.readLock(transactionImpl, identity, object);
    }

    @Override
    public boolean readLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        ClassDescriptor classDescriptor = transactionImpl.getBroker().getClassDescriptor(ProxyHelper.getRealClass(object));
        int n = classDescriptor.getIsolationLevel();
        return this.ignore(n) ? true : this.lm.readLock(transactionImpl.getGUID(), identity, n);
    }

    @Override
    public boolean writeLock(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.writeLock(transactionImpl, identity, object);
    }

    @Override
    public boolean writeLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        ClassDescriptor classDescriptor = transactionImpl.getBroker().getClassDescriptor(ProxyHelper.getRealClass(object));
        int n = classDescriptor.getIsolationLevel();
        return this.ignore(n) ? true : this.lm.writeLock(transactionImpl.getGUID(), identity, n);
    }

    @Override
    public boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.upgradeLock(transactionImpl, identity, object);
    }

    @Override
    public boolean upgradeLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        ClassDescriptor classDescriptor = transactionImpl.getBroker().getClassDescriptor(ProxyHelper.getRealClass(object));
        int n = classDescriptor.getIsolationLevel();
        return this.ignore(n) ? true : this.lm.upgradeLock(transactionImpl.getGUID(), identity, n);
    }

    @Override
    public boolean releaseLock(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.releaseLock(transactionImpl, identity, object);
    }

    @Override
    public boolean releaseLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.lm.releaseLock(transactionImpl.getGUID(), identity);
    }

    @Override
    public boolean checkRead(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.checkRead(transactionImpl, identity, object);
    }

    @Override
    public boolean checkRead(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.lm.hasRead(transactionImpl.getGUID(), identity);
    }

    @Override
    public boolean checkWrite(TransactionImpl transactionImpl, Object object) {
        Identity identity = transactionImpl.getBroker().serviceIdentity().buildIdentity(object);
        return this.checkWrite(transactionImpl, identity, object);
    }

    @Override
    public boolean checkWrite(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.lm.hasWrite(transactionImpl.getGUID(), identity);
    }
}

