/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockListener;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.wait.LockWaitStrategy;

public class ObjectLock {
    private Identity _oid;
    private LockEntry _writer;
    private HashMap _readers = new HashMap();

    public ObjectLock(Identity identity) {
        this._oid = identity;
    }

    public Identity getTargetIdentity() {
        return this._oid;
    }

    public Transaction getWriter() {
        return this._writer == null ? null : this._writer.getTx();
    }

    public boolean isReader(Transaction transaction) {
        return this._readers.containsKey(transaction);
    }

    public boolean doesReaderExists() {
        return this._readers.size() > 0;
    }

    public Collection getReaders() {
        return Collections.unmodifiableCollection(this._readers.keySet());
    }

    public void readLock(Transaction transaction) {
        if (!this.isReader(transaction)) {
            new LockEntry(transaction);
        }
    }

    public void writeLock(Transaction transaction) throws LockingException {
        if (this.getWriter() != transaction) {
            LockEntry lockEntry = (LockEntry)this._readers.get(transaction);
            if (lockEntry == null) {
                lockEntry = new LockEntry(transaction);
            }
            lockEntry.writeLock();
        }
    }

    public void releaseLock(Transaction transaction) {
        LockEntry lockEntry = (LockEntry)this._readers.get(transaction);
        if (lockEntry != null) {
            lockEntry.release();
        }
    }

    public void waitForTx(Transaction transaction) throws LockingException {
        OTMKit oTMKit = transaction.getKit();
        LockWaitStrategy lockWaitStrategy = oTMKit.getLockWaitStrategy();
        lockWaitStrategy.waitForLock(this, transaction);
    }

    public boolean isFree() {
        return this._writer == null && this._readers.isEmpty();
    }

    private class LockEntry {
        public Transaction _tx;
        public ArrayList _listeners;

        public LockEntry(Transaction transaction) {
            this._tx = transaction;
            this._listeners = null;
            ObjectLock.this._readers.put(this._tx, this);
        }

        public ArrayList getListeners() {
            return this._listeners;
        }

        public Transaction getTx() {
            return this._tx;
        }

        public void addListener(LockListener lockListener) {
            if (lockListener != null) {
                if (this._listeners == null) {
                    this._listeners = new ArrayList();
                }
                this._listeners.add(lockListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeLock() throws LockingException {
            while (true) {
                if (ObjectLock.this._writer != null && ((ObjectLock)ObjectLock.this)._writer._tx != this._tx) {
                    ObjectLock.this.waitForTx(this._tx);
                }
                ObjectLock objectLock = ObjectLock.this;
                synchronized (objectLock) {
                    if (ObjectLock.this._writer == null || ((ObjectLock)ObjectLock.this)._writer._tx == this._tx) {
                        ObjectLock.this._writer = this;
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            ObjectLock objectLock = ObjectLock.this;
            synchronized (objectLock) {
                if (ObjectLock.this._writer == this) {
                    ObjectLock.this._writer = null;
                }
            }
            ObjectLock.this._readers.remove(this._tx);
            if (this._listeners != null) {
                for (LockListener lockListener : this._listeners) {
                    lockListener.lockReleased(this._tx, ObjectLock.this._oid);
                }
            }
        }
    }
}

