/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.spring.DwrController;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

public class DwrHandlerMapping
extends SimpleUrlHandlerMapping {
    private static final Log log = LogFactory.getLog(DwrHandlerMapping.class);

    public void initApplicationContext() throws BeansException {
        Object[] dwrControllerName = this.getApplicationContext().getBeanNamesForType(DwrController.class);
        Assert.notEmpty((Object[])dwrControllerName, (String)"No DWR Controller bean definition found.");
        Object handler = this.getApplicationContext().getBean((String)dwrControllerName[0]);
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        mappings.put("/engine.js", handler);
        mappings.put("/util.js", handler);
        mappings.put("/interface/**", handler);
        mappings.put("/call/**", handler);
        mappings.put("/test/**", handler);
        mappings.put("/download/**", handler);
        mappings.put("/jsonp/**", handler);
        mappings.put("/jsonrpc/**", handler);
        mappings.put("/data/Store.js", handler);
        if (log.isDebugEnabled()) {
            log.info((Object)"[engine.js] mapped to dwrController");
            log.info((Object)"[util.js] mapped to dwrController");
            log.info((Object)"Interface beans and calls (/interface/*, /call/*) mapped to dwrController");
            log.info((Object)"/test/* has been mapped to dwrController");
            log.info((Object)"/download/* has been mapped to dwrController");
        }
        this.setUrlMap(mappings);
        super.initApplicationContext();
    }
}

