/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;

public class KRADConfigurer
extends ModuleConfigurer
implements SmartApplicationListener {
    private DataSource applicationDataSource;
    private boolean includeKnsSpringBeans;
    private static final String KRAD_SPRING_BEANS_PATH = "classpath:org/kuali/rice/krad/config/KRADSpringBeans.xml";
    private static final String KNS_SPRING_BEANS_PATH = "classpath:org/kuali/rice/kns/config/KNSSpringBeans.xml";

    public KRADConfigurer() {
        super("kr");
        this.setValidRunModes(Arrays.asList(RunMode.LOCAL));
        this.setIncludeKnsSpringBeans(true);
    }

    public void addAdditonalToConfig() {
        ConfigContext.getCurrentContextConfig().putProperty("rice.krad.kns.enabled", Boolean.valueOf(this.isIncludeKnsSpringBeans()).toString());
        this.configureDataSource();
    }

    public List<String> getPrimarySpringFiles() {
        this.LOG.info("KRADConfigurer:getPrimarySpringFiles: getRunMode => " + this.getRunMode());
        ArrayList<String> springFileLocations = new ArrayList<String>();
        springFileLocations.add(KRAD_SPRING_BEANS_PATH);
        if (this.isIncludeKnsSpringBeans()) {
            springFileLocations.add(KNS_SPRING_BEANS_PATH);
        }
        return springFileLocations;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent) {
            this.loadDataDictionary();
            this.publishDataDictionaryComponents();
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return true;
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public int getOrder() {
        return -1000;
    }

    protected void loadDataDictionary() {
        if (this.isLoadDataDictionary()) {
            this.LOG.info("KRAD Configurer - Loading DD");
            DataDictionaryService dds = KRADServiceLocatorWeb.getDataDictionaryService();
            if (dds == null) {
                dds = (DataDictionaryService)GlobalResourceLoader.getService((String)"dataDictionaryService");
            }
            dds.getDataDictionary().parseDataDictionaryConfigurationFiles();
            if (this.isValidateDataDictionary()) {
                this.LOG.info("KRAD Configurer - Validating DD");
                dds.getDataDictionary().validateDD();
            }
            if (this.isInterfaceBasedOverridesDataDictionary()) {
                dds.getDataDictionary().performBeanOverrides();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishDataDictionaryComponents() {
        if (this.isComponentPublishingEnabled()) {
            long delay = this.getComponentPublishingDelay();
            this.LOG.info("Publishing of Data Dictionary components is enabled, scheduling publish after " + delay + " millisecond delay");
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            try {
                scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        long start = System.currentTimeMillis();
                        KRADConfigurer.this.LOG.info("Executing scheduled Data Dictionary component publishing...");
                        try {
                            KRADServiceLocatorWeb.getDataDictionaryComponentPublisherService().publishAllComponents();
                        }
                        catch (RuntimeException e) {
                            KRADConfigurer.this.LOG.error("Failed to publish data dictionary components.", (Throwable)e);
                            throw e;
                        }
                        finally {
                            long end = System.currentTimeMillis();
                            KRADConfigurer.this.LOG.info("... finished scheduled execution of Data Dictionary component publishing.  Took " + (end - start) + " milliseconds");
                        }
                    }
                }, delay, TimeUnit.MILLISECONDS);
            }
            finally {
                scheduler.shutdown();
            }
        }
    }

    public boolean hasWebInterface() {
        return true;
    }

    public boolean shouldRenderWebInterface() {
        return true;
    }

    public boolean isLoadDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("load.data.dictionary", true);
    }

    public boolean isValidateDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("validate.data.dictionary", false);
    }

    public boolean isInterfaceBasedOverridesDataDictionary() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("interface.based.overrides.data.dictionary", false);
    }

    public boolean isComponentPublishingEnabled() {
        return ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.componentPublishing.enabled", false);
    }

    public long getComponentPublishingDelay() {
        return ConfigContext.getCurrentContextConfig().getNumericProperty("rice.krad.componentPublishing.delay", 0L);
    }

    protected void configureDataSource() {
        if (this.getApplicationDataSource() != null) {
            ConfigContext.getCurrentContextConfig().putObject("kradApplication.datasource", (Object)this.getApplicationDataSource());
        }
    }

    public DataSource getApplicationDataSource() {
        return this.applicationDataSource;
    }

    public void setApplicationDataSource(DataSource applicationDataSource) {
        this.applicationDataSource = applicationDataSource;
    }

    public boolean isIncludeKnsSpringBeans() {
        return this.includeKnsSpringBeans;
    }

    public void setIncludeKnsSpringBeans(boolean includeKnsSpringBeans) {
        this.includeKnsSpringBeans = includeKnsSpringBeans;
    }
}

