/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.exception.AttributeValidationException;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.LegacyDataAdapter;

public final class DataDictionaryPropertyUtils {
    private static final Map<String, Map<String, PropertyDescriptor>> CACHE = new ConcurrentHashMap<String, Map<String, PropertyDescriptor>>();
    private static LegacyDataAdapter legacyDataAdapter;
    private static final Logger LOG;

    private DataDictionaryPropertyUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean isPropertyOf(Class targetClass, String propertyName) {
        if (targetClass == null) {
            throw new IllegalArgumentException("invalid (null) targetClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        try {
            PropertyDescriptor propertyDescriptor = DataDictionaryPropertyUtils.buildReadDescriptor(targetClass, propertyName);
            return propertyDescriptor != null;
        }
        catch (Exception ex) {
            LOG.error("Exception while obtaining property descriptor for " + targetClass.getName() + "." + propertyName, (Throwable)ex);
            return false;
        }
    }

    public static boolean isCollectionPropertyOf(Class targetClass, String propertyName) {
        Class<?> clazz;
        boolean isCollectionPropertyOf = false;
        PropertyDescriptor propertyDescriptor = DataDictionaryPropertyUtils.buildReadDescriptor(targetClass, propertyName);
        if (propertyDescriptor != null && (clazz = propertyDescriptor.getPropertyType()) != null && Collection.class.isAssignableFrom(clazz)) {
            isCollectionPropertyOf = true;
        }
        return isCollectionPropertyOf;
    }

    public static Class getAttributeClass(Class boClass, String attributeName) {
        if (!DataDictionaryPropertyUtils.isPropertyOf(boClass, attributeName)) {
            throw new AttributeValidationException("unable to find attribute '" + attributeName + "' in rootClass '" + boClass.getName() + "'");
        }
        if (boClass.isInterface()) {
            return DataDictionaryPropertyUtils.getAttributeClassWhenBOIsInterface(boClass, attributeName);
        }
        return DataDictionaryPropertyUtils.getAttributeClassWhenBOIsClass(boClass, attributeName);
    }

    private static Class<?> getAttributeClassWhenBOIsClass(Class<?> boClass, String attributeName) {
        Object boInstance;
        try {
            if (boClass.isPrimitive()) {
                boClass = ClassUtils.primitiveToWrapper(boClass);
            }
            boInstance = boClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Data Object: " + boClass, e);
        }
        try {
            return DataDictionaryPropertyUtils.getLegacyDataAdapter().getPropertyType(boInstance, attributeName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to determine property type for: " + boClass.getName() + "." + attributeName, e);
        }
    }

    private static Class<?> getAttributeClassWhenBOIsInterface(Class<?> boClass, String attributeName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        String[] intermediateProperties = attributeName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class currentClass = boClass;
        for (int i = 0; i <= lastLevel; ++i) {
            Class propertyType;
            String currentPropertyName = intermediateProperties[i];
            PropertyDescriptor propertyDescriptor = DataDictionaryPropertyUtils.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor != null) {
                propertyType = propertyDescriptor.getPropertyType();
                if (DataDictionaryPropertyUtils.getLegacyDataAdapter().isExtensionAttribute(currentClass, currentPropertyName, propertyType)) {
                    propertyType = DataDictionaryPropertyUtils.getLegacyDataAdapter().getExtensionAttributeClass(currentClass, currentPropertyName);
                }
                if (Collection.class.isAssignableFrom(propertyType)) {
                    throw new AttributeValidationException("Can't determine the Class of Collection elements because when the business object is an (possibly ExternalizableBusinessObject) interface.");
                }
            } else {
                throw new AttributeValidationException("Can't find getter method of " + boClass.getName() + " for property " + attributeName);
            }
            currentClass = propertyType;
        }
        return currentClass;
    }

    public static Class getCollectionElementClass(Class boClass, String collectionName) {
        if (boClass == null) {
            throw new IllegalArgumentException("invalid (null) boClass");
        }
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalArgumentException("invalid (blank) collectionName");
        }
        String[] intermediateProperties = collectionName.split("\\.");
        Class currentClass = boClass;
        for (String currentPropertyName : intermediateProperties) {
            PropertyDescriptor propertyDescriptor = DataDictionaryPropertyUtils.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (propertyDescriptor == null) continue;
            Class<?> type = propertyDescriptor.getPropertyType();
            currentClass = Collection.class.isAssignableFrom(type) ? DataDictionaryPropertyUtils.getLegacyDataAdapter().determineCollectionObjectType(currentClass, currentPropertyName) : propertyDescriptor.getPropertyType();
        }
        return currentClass;
    }

    private static PropertyDescriptor buildReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        PropertyDescriptor propertyDescriptor = null;
        String[] intermediateProperties = propertyName.split("\\.");
        int lastLevel = intermediateProperties.length - 1;
        Class currentClass = propertyClass;
        for (int i = 0; i <= lastLevel; ++i) {
            String currentPropertyName = intermediateProperties[i];
            propertyDescriptor = DataDictionaryPropertyUtils.buildSimpleReadDescriptor(currentClass, currentPropertyName);
            if (i >= lastLevel || propertyDescriptor == null) continue;
            Class propertyType = propertyDescriptor.getPropertyType();
            if (DataDictionaryPropertyUtils.getLegacyDataAdapter().isExtensionAttribute(currentClass, currentPropertyName, propertyType)) {
                propertyType = DataDictionaryPropertyUtils.getLegacyDataAdapter().getExtensionAttributeClass(currentClass, currentPropertyName);
            }
            currentClass = Collection.class.isAssignableFrom(propertyType) ? DataDictionaryPropertyUtils.getLegacyDataAdapter().determineCollectionObjectType(currentClass, currentPropertyName) : propertyType;
        }
        return propertyDescriptor;
    }

    private static PropertyDescriptor buildSimpleReadDescriptor(Class propertyClass, String propertyName) {
        if (propertyClass == null) {
            throw new IllegalArgumentException("invalid (null) propertyClass");
        }
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("invalid (blank) propertyName");
        }
        Object p = null;
        String propertyClassName = propertyClass.getName();
        Map<String, PropertyDescriptor> m = CACHE.get(propertyClassName);
        if (null != m && null != (p = m.get(propertyName))) {
            return p;
        }
        Object[] descriptors = PropertyUtils.getPropertyDescriptors((Class)propertyClass);
        if (ArrayUtils.isNotEmpty((Object[])descriptors)) {
            for (Object descriptor : descriptors) {
                if (!((FeatureDescriptor)descriptor).getName().equals(propertyName)) continue;
                p = descriptor;
            }
        }
        if (p != null) {
            if (m == null) {
                m = new TreeMap<String, PropertyDescriptor>();
                CACHE.put(propertyClassName, m);
            }
            m.put(propertyName, (PropertyDescriptor)p);
        }
        return p;
    }

    private static LegacyDataAdapter getLegacyDataAdapter() {
        if (legacyDataAdapter == null) {
            legacyDataAdapter = KRADServiceLocatorWeb.getLegacyDataAdapter();
        }
        return legacyDataAdapter;
    }

    static {
        LOG = LogManager.getLogger(DataDictionaryPropertyUtils.class);
    }
}

