/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;
import org.kuali.rice.krad.datadictionary.DataDictionaryPropertyUtils;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

public class SortDefinition
extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = -1092811342186612461L;
    protected boolean sortAscending = true;
    protected List<String> attributeNames = new ArrayList<String>();

    public void setAttributeName(String attributeName) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("invalid (blank) attributeName");
        }
        if (!this.attributeNames.isEmpty()) {
            throw new IllegalStateException("unable to set sort attributeName when sortAttributes have already been added");
        }
        this.attributeNames.add(attributeName);
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        if (this.attributeNames == null || this.attributeNames.isEmpty()) {
            String[] currentValues = new String[]{"attributeNames = " + this.attributeNames, "rootBusinessObjectClass = " + rootBusinessObjectClass};
            tracer.createError("SortDefinition may not have an empty attribute list", currentValues);
        }
        for (String attributeName : this.attributeNames) {
            if (DataDictionaryPropertyUtils.isPropertyOf(rootBusinessObjectClass, attributeName)) continue;
            String[] currentValues = new String[]{"attributeName = " + attributeName, "rootBusinessObjectClass = " + rootBusinessObjectClass};
            tracer.createError("attribute in SortDefinition not found on business object", currentValues);
        }
    }

    public String toString() {
        StringBuilder attrList = new StringBuilder("[");
        Iterator<String> i = this.attributeNames.iterator();
        while (i.hasNext()) {
            attrList.append(i.next());
            if (!i.hasNext()) continue;
            attrList.append(",");
        }
        attrList.append("]");
        return "SortDefinition :  " + attrList;
    }

    public void setAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
    }
}

