/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.field;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.state.StateMapping;
import org.kuali.rice.krad.datadictionary.validation.constraint.CaseConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.MustOccurConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.SimpleConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DelayedCopy;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.MultiValueControlBase;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinder;
import org.kuali.rice.krad.uif.element.FieldValidationMessages;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.AttributeQuery;
import org.kuali.rice.krad.uif.field.DataFieldBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ClientValidationUtils;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.ConstraintStateUtils;
import org.kuali.rice.krad.uif.util.ContextUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ViewModelUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.QuickFinder;
import org.kuali.rice.krad.uif.widget.Suggest;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="input", parent="Uif-InputField"), @BeanTag(name="inputLabelTop", parent="Uif-InputField-LabelTop"), @BeanTag(name="inputLabelRight", parent="Uif-InputField-LabelRight"), @BeanTag(name="checkboxInput", parent="Uif-CheckboxInputField")})
public class InputFieldBase
extends DataFieldBase
implements InputField {
    private static final long serialVersionUID = -3703656713706343840L;
    private ValidCharactersConstraint validCharactersConstraint;
    private CaseConstraint caseConstraint;
    private List<PrerequisiteConstraint> dependencyConstraints;
    private List<MustOccurConstraint> mustOccurConstraints;
    private SimpleConstraint simpleConstraint = new SimpleConstraint();
    private DataType dataType;
    private Control control;
    private boolean inlineEdit;
    private boolean ajaxInlineEdit;
    private KeyValuesFinder optionsFinder;
    private boolean uppercaseValue;
    private boolean disableNativeAutocomplete;
    @DelayedCopy
    private FieldValidationMessages validationMessages;
    private String constraintText;
    private String instructionalText;
    private Message constraintMessage;
    private Message instructionalMessage;
    private String helperText;
    private AttributeQuery attributeQuery;
    private boolean enableAutoDirectInquiry = true;
    private QuickFinder quickfinder;
    private boolean enableAutoQuickfinder = true;
    private Suggest suggest;
    private boolean widgetInputOnly;
    private boolean renderInputAddonGroup;
    private List<String> postInputCssClasses;
    private List<Component> postInputAddons;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        if ((StringUtils.isNotBlank((String)this.constraintText) || this.getPropertyExpression("constraintText") != null) && this.constraintMessage == null) {
            this.constraintMessage = ComponentFactory.getConstraintMessage();
        }
        if ((StringUtils.isNotBlank((String)this.instructionalText) || this.getPropertyExpression("instructionalText") != null) && this.instructionalMessage == null) {
            this.instructionalMessage = ComponentFactory.getInstructionalMessage();
        }
    }

    @Override
    public void afterEvaluateExpression() {
        if (this.getReadOnly() == null) {
            Component parent = ViewLifecycle.getPhase().getParent();
            this.setReadOnly(parent == null ? null : parent.getReadOnly());
        }
        super.afterEvaluateExpression();
    }

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        Object fieldValue;
        MultiValueControlBase multiValueControl;
        super.performApplyModel(model, parent);
        if (StringUtils.isNotBlank((String)this.instructionalText) && this.instructionalMessage != null && StringUtils.isBlank((String)this.instructionalMessage.getMessageText())) {
            this.instructionalMessage.setMessageText(this.instructionalText);
        }
        if (StringUtils.isNotBlank((String)this.constraintText) && this.constraintMessage != null && StringUtils.isBlank((String)this.constraintMessage.getMessageText())) {
            this.constraintMessage.setMessageText(this.constraintText);
        }
        List<Object> fieldOptions = new ArrayList();
        if (this.control != null && this.control instanceof MultiValueControlBase && (multiValueControl = (MultiValueControlBase)this.control).getOptions() != null && !multiValueControl.getOptions().isEmpty()) {
            fieldOptions = multiValueControl.getOptions();
        }
        if (this.control instanceof TextAreaControl) {
            this.setMultiLineReadOnlyDisplay(true);
        }
        if (fieldOptions.isEmpty() && this.optionsFinder != null) {
            if (this.optionsFinder instanceof UifKeyValuesFinder) {
                fieldOptions = ((UifKeyValuesFinder)this.optionsFinder).getKeyValues((ViewModel)model, this);
                if (((UifKeyValuesFinder)this.optionsFinder).isAddBlankOption()) {
                    fieldOptions.add(0, new ConcreteKeyValue("", ""));
                }
            } else {
                fieldOptions = this.optionsFinder.getKeyValues();
            }
            if (this.control != null && this.control instanceof MultiValueControlBase) {
                ((MultiValueControlBase)this.control).setOptions(fieldOptions);
            }
        }
        if (this.enableAutoDirectInquiry && this.getInquiry() == null && this.hasAutoInquiryRelationship()) {
            this.setInquiry(ComponentFactory.getInquiry());
        }
        if (this.enableAutoQuickfinder && this.getQuickfinder() == null && this.hasAutoQuickfinderRelationship()) {
            this.setQuickfinder(ComponentFactory.getQuickFinder());
            ContextUtils.pushAllToContextDeep(this.quickfinder, this.getContext());
        }
        if (Boolean.TRUE.equals(this.getReadOnly()) && !fieldOptions.isEmpty() && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacement()) && StringUtils.isBlank((String)this.getReadOnlyDisplaySuffix()) && StringUtils.isBlank((String)this.getReadOnlyDisplayReplacementPropertyName()) && StringUtils.isBlank((String)this.getReadOnlyDisplaySuffixPropertyName()) && (fieldValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath())) != null && TypeUtils.isSimpleType(fieldValue.getClass())) {
            for (KeyValue keyValue : fieldOptions) {
                if (!StringUtils.equals((String)fieldValue.toString(), (String)keyValue.getKey())) continue;
                this.setReadOnlyDisplayReplacement(keyValue.getValue());
                break;
            }
        }
        if (this.control != null && this.quickfinder != null && this.quickfinder.getQuickfinderAction() != null) {
            String disabledExpression = this.control.getPropertyExpression("disabled");
            if (StringUtils.isNotBlank((String)disabledExpression)) {
                this.quickfinder.getQuickfinderAction().getPropertyExpressions().put("disabled", disabledExpression);
            } else {
                this.quickfinder.getQuickfinderAction().setDisabled(this.control.isDisabled());
            }
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        boolean ajaxInlineEditRefresh;
        super.performFinalize(model, parent);
        this.setupIds();
        this.addDataAttribute("role", "InputField");
        boolean bl = ajaxInlineEditRefresh = this.ajaxInlineEdit && ((UifFormBase)model).getUpdateComponentId() != null && ((UifFormBase)model).getUpdateComponentId().equals(this.getId());
        if (Boolean.TRUE.equals(this.getReadOnly()) && !this.inlineEdit && !ajaxInlineEditRefresh || this.getControl() == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)this.helperText) && this.getControl() != null) {
            this.getControl().getCssClasses().add("has-helper");
        }
        DataDictionaryService dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        if (this.getDictionaryObjectEntry() != null && this.getDictionaryAttributeName() != null) {
            Object currentPropertyValue;
            AttributeDefinition ad = dataDictionaryService.getAttributeDefinition(this.getDictionaryObjectEntry(), this.getDictionaryAttributeName());
            Map<String, String> propertyExpressions = this.getPropertyExpressions();
            if (propertyExpressions.containsKey("dictionaryAttributeName")) {
                this.copyFromAttributeDefinition(ad);
            }
            if ((ad.getForceUppercase().booleanValue() || this.uppercaseValue) && (currentPropertyValue = ObjectPropertyUtils.getPropertyValue(model, this.getBindingInfo().getBindingPath())) instanceof String) {
                String uppercasedValue = ((String)currentPropertyValue).toUpperCase();
                ObjectPropertyUtils.setPropertyValue(model, this.getBindingInfo().getBindingPath(), uppercasedValue);
            }
        }
        if (this.suggest != null && this.suggest.isSuggestConfigured()) {
            this.setDisableNativeAutocomplete(true);
        }
        this.adjustPrerequisiteConstraintBinding(this.dependencyConstraints);
        this.adjustMustOccurConstraintBinding(this.mustOccurConstraints);
        if (this.caseConstraint != null) {
            String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(this.caseConstraint.getPropertyName());
            this.caseConstraint.setPropertyName(propertyName);
        }
        View view = ViewLifecycle.getView();
        this.setupFieldQuery(view);
        String path = view.getStateObjectBindingPath();
        Object stateObject = StringUtils.isNotBlank((String)path) ? ObjectPropertyUtils.getPropertyValue(model, path) : model;
        StateMapping stateMapping = view.getStateMapping();
        String nextStateReqIndicator = (String)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean("Uif-RequiredIndicator-ForNextState");
        if (stateMapping != null) {
            SimpleConstraint prevConstraint;
            String validationState = ConstraintStateUtils.getClientViewValidationState(model, view);
            SimpleConstraint appliedSimpleConstraint = ConstraintStateUtils.getApplicableConstraint(this.getSimpleConstraint(), validationState, stateMapping);
            if (appliedSimpleConstraint != null && appliedSimpleConstraint.getRequired() != null && appliedSimpleConstraint.getRequired().booleanValue() && ((prevConstraint = ConstraintStateUtils.getApplicableConstraint(this.getSimpleConstraint(), stateMapping.getCurrentState(stateObject), stateMapping)) == null || prevConstraint.getRequired() == null || !prevConstraint.getRequired().booleanValue())) {
                this.getFieldLabel().setRequiredIndicator(nextStateReqIndicator);
            }
        }
        ClientValidationUtils.processAndApplyConstraints(this, view, model);
        if (this.inlineEdit || this.ajaxInlineEdit) {
            this.addDataAttribute("inline_edit", "true");
        }
        if (this.validationMessages != null) {
            if (this.inlineEdit || this.ajaxInlineEdit) {
                this.validationMessages.setUseTooltip(false);
            }
            this.validationMessages.generateMessages(view, model, this);
        }
        this.addComponentPostMetadata();
        if (this.getHelp() != null && StringUtils.isNotBlank((String)this.getHelp().getExternalHelpUrl())) {
            this.setRenderInputAddonGroup(true);
        }
    }

    protected void addComponentPostMetadata() {
        ViewPostMetadata viewPostMetadata = ViewLifecycle.getViewPostMetadata();
        viewPostMetadata.getInputFieldIds().add(this.getId());
        viewPostMetadata.addComponentPostData(this, "label", (Object)this.getLabel());
        viewPostMetadata.addComponentPostData(this, "path", (Object)this.getName());
        viewPostMetadata.addComponentPostData(this, "simpleConstraint", (Object)this.getSimpleConstraint());
        viewPostMetadata.addComponentPostData(this, "validCharacterConstraint", (Object)this.getValidCharactersConstraint());
        viewPostMetadata.addComponentPostData(this, "caseConstraint", (Object)this.getCaseConstraint());
        viewPostMetadata.addComponentPostData(this, "mustOccurConstraints", this.getMustOccurConstraints());
        viewPostMetadata.addComponentPostData(this, "prerequisiteConstraints", this.getPrerequisiteConstraints());
        viewPostMetadata.addComponentPostData(this, "attributeQuery", (Object)this.attributeQuery);
        if (this.suggest != null) {
            viewPostMetadata.addComponentPostData(this, "suggest", (Object)this.suggest.getPostData());
        }
        viewPostMetadata.addComponentPostData(this, "isUppercase", (Object)this.isUppercaseValue());
        if ((this.isRender() || StringUtils.isNotBlank((String)this.getProgressiveRender())) && !this.isHidden() && (!Boolean.TRUE.equals(this.getReadOnly()) || this.inlineEdit || this.ajaxInlineEdit)) {
            viewPostMetadata.addAccessibleBindingPath(this.getBindingInfo().getBindingPath());
        }
    }

    @Override
    protected void processReadOnlyListDisplay(Object model, List<?> originalList) {
        if (this.control != null && this.control instanceof MultiValueControlBase) {
            ArrayList<String> newList = new ArrayList<String>();
            List<KeyValue> fieldOptions = ((MultiValueControlBase)this.control).getOptions();
            if (fieldOptions == null || fieldOptions.isEmpty()) {
                return;
            }
            block0: for (Object fieldValue : originalList) {
                for (KeyValue keyValue : fieldOptions) {
                    if (fieldValue == null || !StringUtils.equals((String)fieldValue.toString(), (String)keyValue.getKey())) continue;
                    newList.add(keyValue.getValue());
                    continue block0;
                }
            }
            this.setReadOnlyDisplayReplacement(super.generateReadOnlyListDisplayReplacement(newList));
        } else {
            this.setReadOnlyDisplayReplacement(super.generateReadOnlyListDisplayReplacement(originalList));
        }
    }

    @Override
    protected void setAlternateAndAdditionalDisplayValue(View view, Object model) {
        if (StringUtils.isNotBlank((String)this.getReadOnlyDisplayReplacement()) || StringUtils.isNotBlank((String)this.getReadOnlyDisplaySuffix())) {
            return;
        }
        if (this.isApplyMask()) {
            if (this.quickfinder != null && StringUtils.isNotBlank((String)this.quickfinder.getDataObjectClassName())) {
                this.setWidgetInputOnly(true);
            } else {
                String maintenanceAction = null;
                if (view.getViewTypeName().equals((Object)UifConstants.ViewType.MAINTENANCE)) {
                    maintenanceAction = ((MaintenanceDocumentForm)model).getMaintenanceAction();
                }
                if (!view.getViewTypeName().equals((Object)UifConstants.ViewType.LOOKUP) && !"Copy".equals(maintenanceAction)) {
                    this.setReadOnly(true);
                }
            }
        }
        super.setAlternateAndAdditionalDisplayValue(view, model);
    }

    protected void adjustMustOccurConstraintBinding(List<MustOccurConstraint> mustOccurConstraints) {
        if (mustOccurConstraints != null) {
            for (MustOccurConstraint mustOccurConstraint : mustOccurConstraints) {
                this.adjustPrerequisiteConstraintBinding(mustOccurConstraint.getPrerequisiteConstraints());
                this.adjustMustOccurConstraintBinding(mustOccurConstraint.getMustOccurConstraints());
            }
        }
    }

    protected void adjustPrerequisiteConstraintBinding(List<PrerequisiteConstraint> prerequisiteConstraints) {
        if (prerequisiteConstraints != null) {
            for (PrerequisiteConstraint prerequisiteConstraint : prerequisiteConstraints) {
                String propertyName = this.getBindingInfo().getPropertyAdjustedBindingPath(prerequisiteConstraint.getPropertyName());
                prerequisiteConstraint.setPropertyName(propertyName);
            }
        }
    }

    protected void setupFieldQuery(View view) {
        if (this.getAttributeQuery() != null) {
            this.getAttributeQuery().defaultQueryTarget(view.getViewHelperService());
            this.getAttributeQuery().updateQueryFieldMapping(this.getBindingInfo());
            this.getAttributeQuery().updateReturnFieldMapping(this.getBindingInfo());
            this.getAttributeQuery().updateQueryMethodArgumentFieldList(this.getBindingInfo());
            String script = "executeFieldQuery('" + this.getControl().getId() + "',";
            script = script + "'" + this.getId() + "'," + this.getAttributeQuery().getQueryFieldMappingJsString() + ",";
            script = script + this.getAttributeQuery().getQueryMethodArgumentFieldsJsString() + ",";
            script = script + this.getAttributeQuery().getReturnFieldMappingJsString() + ");";
            this.setRenderInfoMessageSpan(true);
            if (StringUtils.isNotBlank((String)this.getControl().getOnBlurScript())) {
                script = this.getControl().getOnBlurScript() + script;
            }
            this.getControl().setOnBlurScript(script);
        }
    }

    protected void setupIds() {
        this.setNestedComponentIdAndSuffix(this.getControl(), "_control");
        this.setNestedComponentIdAndSuffix(this.getFieldLabel(), "_label");
        this.setNestedComponentIdAndSuffix(this.getInstructionalMessage(), "_instructional");
        this.setNestedComponentIdAndSuffix(this.getConstraintMessage(), "_constraint");
        this.setNestedComponentIdAndSuffix(this.getQuickfinder(), "_quickfinder");
        this.setNestedComponentIdAndSuffix(this.getSuggest(), "_suggest");
        if (this.getControl() != null) {
            this.getControl().addDataAttribute("control_for", this.getId());
        }
    }

    @Override
    public void copyFromAttributeDefinition(AttributeDefinition attributeDefinition) {
        super.copyFromAttributeDefinition(attributeDefinition);
        if (this.getMaxLength() == null) {
            this.setMaxLength(attributeDefinition.getMaxLength());
        }
        if (this.getMinLength() == null) {
            this.setMinLength(attributeDefinition.getMinLength());
        }
        if (this.getValidCharactersConstraint() == null) {
            this.setValidCharactersConstraint(attributeDefinition.getValidCharactersConstraint());
        }
        if (this.getCaseConstraint() == null) {
            this.setCaseConstraint(attributeDefinition.getCaseConstraint());
        }
        if (this.getDependencyConstraints() == null) {
            this.setDependencyConstraints(attributeDefinition.getPrerequisiteConstraints());
        }
        if (this.getMustOccurConstraints() == null) {
            this.setMustOccurConstraints(attributeDefinition.getMustOccurConstraints());
        }
        if (this.getRequired() == null) {
            this.setRequired(attributeDefinition.isRequired());
            if (this.getRequired() == null) {
                this.setRequired(Boolean.FALSE);
            }
        }
        if (this.getDataType() == null) {
            this.setDataType(attributeDefinition.getDataType());
            if (this.getDataType() == null && this.control instanceof TextControl && ((TextControl)this.control).getDatePicker() != null) {
                this.setDataType(DataType.DATE);
            }
        }
        if (this.getControl() == null && attributeDefinition.getControlField() != null) {
            Control control = ComponentUtils.copy(attributeDefinition.getControlField());
            this.setControl(control);
        }
        if (StringUtils.isEmpty((String)this.getConstraintText())) {
            this.setConstraintText(attributeDefinition.getConstraintText());
            if (this.constraintMessage == null) {
                this.constraintMessage = ComponentFactory.getConstraintMessage();
            }
            this.getConstraintMessage().setMessageText(attributeDefinition.getConstraintText());
        }
        if (this.getOptionsFinder() == null) {
            this.setOptionsFinder(attributeDefinition.getOptionsFinder());
        }
        if (this.getSimpleConstraint().getConstraintStateOverrides() == null) {
            this.getSimpleConstraint().setConstraintStateOverrides(attributeDefinition.getSimpleConstraint().getConstraintStateOverrides());
        }
        if (this.getSimpleConstraint().getStates().isEmpty()) {
            this.getSimpleConstraint().setStates(attributeDefinition.getSimpleConstraint().getStates());
        }
        if (this.getSimpleConstraint().getMessageKey() == null) {
            this.getSimpleConstraint().setMessageKey(attributeDefinition.getSimpleConstraint().getMessageKey());
        }
        if (this.getSimpleConstraint().getApplyClientSide() == null) {
            this.getSimpleConstraint().setApplyClientSide(attributeDefinition.getSimpleConstraint().getApplyClientSide());
        }
        if (this.getSimpleConstraint().getValidationMessageParams() == null) {
            this.getSimpleConstraint().setValidationMessageParams(attributeDefinition.getSimpleConstraint().getValidationMessageParams());
        }
    }

    @Override
    public boolean isInputAllowed() {
        return true;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.BYTYPE)
    public Control getControl() {
        return this.control;
    }

    @Override
    public void setControl(Control control) {
        this.control = control;
    }

    @Override
    @BeanTagAttribute
    public boolean isInlineEdit() {
        return this.inlineEdit;
    }

    @Override
    public void setInlineEdit(boolean inlineEdit) {
        this.inlineEdit = inlineEdit;
    }

    @Override
    @BeanTagAttribute
    public boolean isAjaxInlineEdit() {
        return this.ajaxInlineEdit;
    }

    @Override
    public void setAjaxInlineEdit(boolean ajaxInlineEdit) {
        this.ajaxInlineEdit = ajaxInlineEdit;
    }

    @Override
    @ViewLifecycleRestriction
    @BeanTagAttribute
    public FieldValidationMessages getValidationMessages() {
        return this.validationMessages;
    }

    @Override
    public void setValidationMessages(FieldValidationMessages validationMessages) {
        this.validationMessages = validationMessages;
    }

    @Override
    @BeanTagAttribute
    public KeyValuesFinder getOptionsFinder() {
        return this.optionsFinder;
    }

    @Override
    public void setOptionsFinder(KeyValuesFinder optionsFinder) {
        this.optionsFinder = optionsFinder;
    }

    @Override
    @BeanTagAttribute
    public Class<? extends KeyValuesFinder> getOptionsFinderClass() {
        if (this.optionsFinder != null) {
            return this.optionsFinder.getClass();
        }
        return null;
    }

    @Override
    public void setOptionsFinderClass(Class<? extends KeyValuesFinder> optionsFinderClass) {
        this.optionsFinder = KRADUtils.createNewObjectFromClass(optionsFinderClass);
    }

    @Override
    @BeanTagAttribute
    public boolean isEnableAutoDirectInquiry() {
        return this.enableAutoDirectInquiry;
    }

    @Override
    public void setEnableAutoDirectInquiry(boolean enableAutoDirectInquiry) {
        this.enableAutoDirectInquiry = enableAutoDirectInquiry;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public QuickFinder getQuickfinder() {
        return this.quickfinder;
    }

    @Override
    public void setQuickfinder(QuickFinder quickfinder) {
        this.quickfinder = quickfinder;
    }

    @Override
    @BeanTagAttribute
    public boolean isEnableAutoQuickfinder() {
        return this.enableAutoQuickfinder;
    }

    @Override
    public void setEnableAutoQuickfinder(boolean enableAutoQuickfinder) {
        this.enableAutoQuickfinder = enableAutoQuickfinder;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public Suggest getSuggest() {
        return this.suggest;
    }

    @Override
    public void setSuggest(Suggest suggest) {
        this.suggest = suggest;
    }

    @Override
    @BeanTagAttribute
    public boolean isWidgetInputOnly() {
        return this.widgetInputOnly;
    }

    @Override
    public void setWidgetInputOnly(boolean widgetInputOnly) {
        this.widgetInputOnly = widgetInputOnly;
    }

    @Override
    @BeanTagAttribute
    public boolean isRenderInputAddonGroup() {
        return this.renderInputAddonGroup;
    }

    @Override
    public void setRenderInputAddonGroup(boolean renderInputAddonGroup) {
        this.renderInputAddonGroup = renderInputAddonGroup;
    }

    @Override
    @BeanTagAttribute
    public List<String> getPostInputCssClasses() {
        return this.postInputCssClasses;
    }

    @Override
    public String getPostInputCssClassesAsString() {
        if (this.postInputCssClasses != null) {
            return StringUtils.join(this.postInputCssClasses, (String)" ");
        }
        return "";
    }

    @Override
    public void setPostInputCssClasses(List<String> postInputCssClasses) {
        this.postInputCssClasses = postInputCssClasses;
    }

    @Override
    @BeanTagAttribute
    public List<Component> getPostInputAddons() {
        return this.postInputAddons;
    }

    @Override
    public void setPostInputAddons(List<Component> postInputAddons) {
        this.postInputAddons = postInputAddons;
    }

    @Override
    public void addPostInputAddon(Component addOn) {
        if (this.postInputAddons == null) {
            this.postInputAddons = new ArrayList<Component>();
        }
        this.postInputAddons.add(addOn);
    }

    @Override
    @BeanTagAttribute
    public String getInstructionalText() {
        return this.instructionalText;
    }

    @Override
    public void setInstructionalText(String instructionalText) {
        this.instructionalText = instructionalText;
    }

    @Override
    @BeanTagAttribute
    public Message getInstructionalMessage() {
        return this.instructionalMessage;
    }

    @Override
    public void setInstructionalMessage(Message instructionalMessage) {
        this.instructionalMessage = instructionalMessage;
    }

    @Override
    @BeanTagAttribute
    public String getHelperText() {
        return this.helperText;
    }

    @Override
    public void setHelperText(String helperText) {
        this.helperText = helperText;
    }

    @Override
    @BeanTagAttribute
    public String getConstraintText() {
        return this.constraintText;
    }

    @Override
    public void setConstraintText(String constraintText) {
        this.constraintText = constraintText;
    }

    @Override
    @BeanTagAttribute
    public Message getConstraintMessage() {
        return this.constraintMessage;
    }

    @Override
    public void setConstraintMessage(Message constraintMessage) {
        this.constraintMessage = constraintMessage;
    }

    @Override
    @BeanTagAttribute
    public ValidCharactersConstraint getValidCharactersConstraint() {
        return this.validCharactersConstraint;
    }

    @Override
    public void setValidCharactersConstraint(ValidCharactersConstraint validCharactersConstraint) {
        this.validCharactersConstraint = validCharactersConstraint;
    }

    @Override
    @BeanTagAttribute
    public CaseConstraint getCaseConstraint() {
        return this.caseConstraint;
    }

    @Override
    public void setCaseConstraint(CaseConstraint caseConstraint) {
        this.caseConstraint = caseConstraint;
    }

    @Override
    @BeanTagAttribute
    public List<PrerequisiteConstraint> getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    public void setDependencyConstraints(List<PrerequisiteConstraint> dependencyConstraints) {
        this.dependencyConstraints = dependencyConstraints;
    }

    @Override
    public List<PrerequisiteConstraint> getPrerequisiteConstraints() {
        return this.dependencyConstraints;
    }

    @Override
    @BeanTagAttribute
    public List<MustOccurConstraint> getMustOccurConstraints() {
        return this.mustOccurConstraints;
    }

    @Override
    public void setMustOccurConstraints(List<MustOccurConstraint> mustOccurConstraints) {
        this.mustOccurConstraints = mustOccurConstraints;
    }

    @Override
    @BeanTagAttribute
    public SimpleConstraint getSimpleConstraint() {
        return this.simpleConstraint;
    }

    @Override
    public void setSimpleConstraint(SimpleConstraint simpleConstraint) {
        this.simpleConstraint = simpleConstraint;
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public DataType getDataType() {
        return this.simpleConstraint.getDataType();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.simpleConstraint.setDataType(dataType);
    }

    @Override
    public void setDataType(String dataType) {
        this.simpleConstraint.setDataType(DataType.valueOf((String)dataType));
    }

    @Override
    @BeanTagAttribute
    public Integer getMaxLength() {
        return this.simpleConstraint.getMaxLength();
    }

    @Override
    public void setMaxLength(Integer maxLength) {
        this.simpleConstraint.setMaxLength(maxLength);
    }

    @Override
    @BeanTagAttribute
    public Integer getMinLength() {
        return this.simpleConstraint.getMinLength();
    }

    @Override
    public void setMinLength(Integer minLength) {
        this.simpleConstraint.setMinLength(minLength);
    }

    @Override
    @BeanTagAttribute
    public Boolean getRequired() {
        return this.simpleConstraint.getRequired();
    }

    @Override
    public void setRequired(Boolean required) {
        this.simpleConstraint.setRequired(required);
    }

    @Override
    @BeanTagAttribute
    public String getExclusiveMin() {
        return this.simpleConstraint.getExclusiveMin();
    }

    @Override
    public void setExclusiveMin(String exclusiveMin) {
        this.simpleConstraint.setExclusiveMin(exclusiveMin);
    }

    @Override
    @BeanTagAttribute
    public String getInclusiveMax() {
        return this.simpleConstraint.getInclusiveMax();
    }

    @Override
    public void setInclusiveMax(String inclusiveMax) {
        this.simpleConstraint.setInclusiveMax(inclusiveMax);
    }

    @Override
    @BeanTagAttribute(type=BeanTagAttribute.AttributeType.DIRECTORBYTYPE)
    public AttributeQuery getAttributeQuery() {
        return this.attributeQuery;
    }

    @Override
    public void setAttributeQuery(AttributeQuery attributeQuery) {
        this.attributeQuery = attributeQuery;
    }

    @Override
    @BeanTagAttribute
    public boolean isUppercaseValue() {
        return this.uppercaseValue;
    }

    @Override
    public void setUppercaseValue(boolean uppercaseValue) {
        this.uppercaseValue = uppercaseValue;
    }

    @Override
    @BeanTagAttribute
    public boolean isDisableNativeAutocomplete() {
        return this.disableNativeAutocomplete;
    }

    @Override
    public void setDisableNativeAutocomplete(boolean disableNativeAutocomplete) {
        this.disableNativeAutocomplete = disableNativeAutocomplete;
    }

    @Override
    public boolean isRenderFieldset() {
        return super.isRenderFieldset() || this.quickfinder != null && this.quickfinder.isRender() && this.quickfinder.getQuickfinderAction() != null && this.quickfinder.getQuickfinderAction().isRender();
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        if (this.getControl() == null && Validator.checkExpressions(this, "control")) {
            currentValues = new String[]{"propertyName =" + this.getPropertyName()};
            tracer.createWarning("Control should be set", currentValues);
        }
        if (this.getControl() != null && !(this.getControl() instanceof TextControl) && !(this.getControl() instanceof TextAreaControl) && !(this.getControl() instanceof SelectControl) && CollectionUtils.isNotEmpty(this.getPostInputAddons())) {
            currentValues = new String[]{"propertyName =" + this.getPropertyName()};
            tracer.createWarning("Inputs which are not text or select should not use post input addons for user experience reasons", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }

    protected boolean hasAutoQuickfinderRelationship() {
        String propertyName = this.getBindingInfo().getBindingName();
        View view = ViewLifecycle.getView();
        Object model = ViewLifecycle.getModel();
        Object parentObject = ViewModelUtils.getParentObjectForMetadata(view, model, this);
        Class<?> parentObjectClass = null;
        if (parentObject != null) {
            parentObjectClass = parentObject.getClass();
        }
        DataObjectRelationship relationship = null;
        if (parentObject != null) {
            relationship = KRADServiceLocatorWeb.getLegacyDataAdapter().getDataObjectRelationship(parentObject, parentObjectClass, propertyName, "", true, true, false);
        }
        return relationship != null;
    }
}

