/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.CssConstants;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.MultiFileUploadCollection;
import org.kuali.rice.krad.uif.element.ProgressBar;
import org.kuali.rice.krad.uif.field.ProgressBarField;
import org.kuali.rice.krad.uif.layout.LayoutManagerBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTags(value={@BeanTag(name="boxLayout", parent="Uif-BoxLayoutBase"), @BeanTag(name="horizontalBoxLayout", parent="Uif-HorizontalBoxLayout"), @BeanTag(name="verticalBoxLayout", parent="Uif-VerticalBoxLayout")})
public class BoxLayoutManager
extends LayoutManagerBase {
    private static final long serialVersionUID = 4467342272983290044L;
    private UifConstants.Orientation orientation = UifConstants.Orientation.HORIZONTAL;
    private String padding;
    private String itemStyle = "";
    private List<String> itemStyleClasses = new ArrayList<String>();
    private boolean renderLayoutWrapper;

    @Override
    public void performFinalize(Object model, LifecycleElement container) {
        super.performFinalize(model, container);
        if (StringUtils.isBlank((String)this.itemStyle)) {
            this.itemStyle = "";
        }
        if (StringUtils.isNotEmpty((String)this.padding)) {
            this.itemStyle = this.orientation.equals((Object)UifConstants.Orientation.VERTICAL) ? this.itemStyle + CssConstants.getCssStyle("padding-bottom: {0};", this.padding) : this.itemStyle + CssConstants.getCssStyle("padding-right: {0};", this.padding);
        }
        for (Component component : ((Container)container).getItems()) {
            if (component == null) continue;
            if (this.orientation.equals((Object)UifConstants.Orientation.HORIZONTAL)) {
                component.addStyleClass("uif-boxLayoutHorizontalItem");
                ((Component)container).addStyleClass("clearfix");
                for (String styleClass : this.getItemStyleClasses()) {
                    component.addStyleClass(styleClass);
                }
            } else {
                component.addStyleClass("uif-boxLayoutVerticalItem");
                if (!(component instanceof Header || component instanceof Container || component instanceof Message || component instanceof ProgressBar || component instanceof ProgressBarField || component instanceof MultiFileUploadCollection)) {
                    component.addStyleClass("pull-left");
                }
                for (String styleClass : this.getItemStyleClasses()) {
                    component.addStyleClass(styleClass);
                }
                component.addStyleClass("clearfix");
            }
            if (component.getStyle() != null && !component.getStyle().endsWith(";")) {
                component.appendToStyle(";" + this.getItemStyle());
                continue;
            }
            component.appendToStyle(this.getItemStyle());
        }
    }

    @BeanTagAttribute
    public UifConstants.Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(UifConstants.Orientation orientation) {
        this.orientation = orientation;
    }

    @BeanTagAttribute
    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    @BeanTagAttribute
    public String getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(String itemStyle) {
        this.itemStyle = itemStyle;
    }

    @BeanTagAttribute
    public List<String> getItemStyleClasses() {
        return this.itemStyleClasses;
    }

    public void setItemStyleClasses(List<String> itemStyleClasses) {
        this.itemStyleClasses = itemStyleClasses;
    }

    public String getItemStyleClassesAsString() {
        if (this.itemStyleClasses != null) {
            return StringUtils.join(this.itemStyleClasses, (String)" ");
        }
        return "";
    }

    public boolean isRenderLayoutWrapper() {
        return this.renderLayoutWrapper;
    }

    public void setRenderLayoutWrapper(boolean renderLayoutWrapper) {
        this.renderLayoutWrapper = renderLayoutWrapper;
    }
}

