/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.freemarker.RenderComponentTask;
import org.kuali.rice.krad.uif.lifecycle.ApplyModelComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.FinalizeComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.InitializeComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.PreProcessElementPhase;
import org.kuali.rice.krad.uif.lifecycle.RenderComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.RunComponentModifiersTask;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhaseBuilder;
import org.kuali.rice.krad.uif.lifecycle.finalize.AddFocusAndJumpDataAttributesTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.AddViewTemplatesTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.ComponentDefaultFinalizeTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.FinalizeViewTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.HelperCustomFinalizeTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.InvokeFinalizerTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.RegisterPropertyEditorTask;
import org.kuali.rice.krad.uif.lifecycle.finalize.SetReadOnlyOnDataBindingTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.AssignIdsTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.ComponentDefaultInitializeTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.HelperCustomInitializeTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.InitializeContainerFromHelperTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.InitializeDataFieldFromDictionaryTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.PopulateComponentFromExpressionGraphTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.PopulatePathTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.PopulateReplacersAndModifiersFromExpressionGraphTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.PrepareForCacheTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.ProcessRemoteFieldsHolderTask;
import org.kuali.rice.krad.uif.lifecycle.initialize.SortContainerTask;
import org.kuali.rice.krad.uif.lifecycle.model.AfterEvaluateExpressionTask;
import org.kuali.rice.krad.uif.lifecycle.model.ApplyAuthAndPresentationLogicTask;
import org.kuali.rice.krad.uif.lifecycle.model.ComponentDefaultApplyModelTask;
import org.kuali.rice.krad.uif.lifecycle.model.EvaluateExpressionsTask;
import org.kuali.rice.krad.uif.lifecycle.model.HelperCustomApplyModelTask;
import org.kuali.rice.krad.uif.lifecycle.model.PopulateComponentContextTask;
import org.kuali.rice.krad.uif.lifecycle.model.RefreshStateModifyTask;
import org.kuali.rice.krad.uif.lifecycle.model.SuffixIdFromContainerTask;
import org.kuali.rice.krad.uif.lifecycle.model.SyncClientSideStateTask;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.View;

public class ViewLifecyclePhaseBuilderBase
implements ViewLifecyclePhaseBuilder {
    @Override
    public ViewLifecyclePhase buildPhase(View view, String viewPhase, List<String> refreshPaths) {
        return this.buildPhase(viewPhase, view, null, "", refreshPaths);
    }

    @Override
    public ViewLifecyclePhase buildPhase(String viewPhase, LifecycleElement element, Component parent, String parentPath, List<String> refreshPaths) {
        ViewLifecyclePhase phase = this.getPhaseInstance(viewPhase);
        phase.prepare(element, parent, parentPath, refreshPaths);
        return this.finishBuildPhase(phase);
    }

    protected ViewLifecyclePhase finishBuildPhase(ViewLifecyclePhase phase) {
        String previousViewPhase = ViewLifecyclePhaseBuilderBase.getPreviousViewPhase(phase);
        while (previousViewPhase != null) {
            ViewLifecyclePhase prevPhase = this.getPhaseInstance(previousViewPhase);
            prevPhase.prepare(phase.getElement(), phase.getParent(), phase.getParentPath(), phase.getRefreshPaths());
            prevPhase.setNextPhase(phase);
            phase = prevPhase;
            previousViewPhase = ViewLifecyclePhaseBuilderBase.getPreviousViewPhase(phase);
        }
        return phase;
    }

    protected static String getPreviousViewPhase(ViewLifecyclePhase phase) {
        String viewPhase = phase.getViewPhase();
        if ("FINALIZE".equals(viewPhase) && !phase.getElement().isModelApplied()) {
            return "APPLY_MODEL";
        }
        if ("APPLY_MODEL".equals(viewPhase) && !phase.getElement().isInitialized()) {
            return "INITIALIZE";
        }
        return null;
    }

    protected ViewLifecyclePhase getPhaseInstance(String viewPhase) {
        ViewLifecyclePhase phase = RecycleUtils.getRecycledInstance(viewPhase, ViewLifecyclePhase.class);
        if (phase != null) {
            return phase;
        }
        if ("PRE_PROCESS".equals(viewPhase)) {
            phase = this.buildPreProcessPhase();
        } else if ("INITIALIZE".equals(viewPhase)) {
            phase = this.buildInitializePhase();
        } else if ("APPLY_MODEL".equals(viewPhase)) {
            phase = this.buildApplyModelPhase();
        } else if ("FINALIZE".equals(viewPhase)) {
            phase = this.buildFinalizePhase();
        } else if ("RENDER".equals(viewPhase)) {
            phase = this.buildRenderPhase();
        }
        if (phase == null) {
            throw new RuntimeException("Cannnot create phase instance for view phase name: " + viewPhase);
        }
        return phase;
    }

    protected ViewLifecyclePhase buildPreProcessPhase() {
        PreProcessElementPhase phase = new PreProcessElementPhase();
        ArrayList tasks = new ArrayList();
        tasks.add(new AssignIdsTask());
        tasks.add(new PopulatePathTask());
        tasks.add(new SortContainerTask());
        tasks.add(new PrepareForCacheTask());
        phase.setTasks(tasks);
        phase.setSkipLifecycleTasks(new ArrayList());
        return phase;
    }

    protected ViewLifecyclePhase buildInitializePhase() {
        InitializeComponentPhase phase = new InitializeComponentPhase();
        ArrayList tasks = new ArrayList();
        tasks.add(new AssignIdsTask());
        tasks.add(new PopulatePathTask());
        tasks.add(new PopulateComponentFromExpressionGraphTask());
        tasks.add(new ComponentDefaultInitializeTask());
        tasks.add(new InitializeDataFieldFromDictionaryTask());
        tasks.add(new PopulateReplacersAndModifiersFromExpressionGraphTask());
        tasks.add(new InitializeContainerFromHelperTask());
        tasks.add(new ProcessRemoteFieldsHolderTask());
        tasks.add(new InitializeDataFieldFromDictionaryTask());
        tasks.add(new RunComponentModifiersTask());
        tasks.add(new HelperCustomInitializeTask());
        phase.setTasks(tasks);
        ArrayList skipLifecycleTasks = new ArrayList();
        skipLifecycleTasks.add(new AssignIdsTask());
        phase.setSkipLifecycleTasks(skipLifecycleTasks);
        return phase;
    }

    protected ViewLifecyclePhase buildApplyModelPhase() {
        ApplyModelComponentPhase phase = new ApplyModelComponentPhase();
        ArrayList tasks = new ArrayList();
        tasks.add(new SuffixIdFromContainerTask());
        tasks.add(new PopulateComponentContextTask());
        tasks.add(new EvaluateExpressionsTask());
        tasks.add(new AfterEvaluateExpressionTask());
        tasks.add(new SyncClientSideStateTask());
        tasks.add(new ApplyAuthAndPresentationLogicTask());
        tasks.add(new RefreshStateModifyTask());
        tasks.add(new ComponentDefaultApplyModelTask());
        tasks.add(new RunComponentModifiersTask());
        tasks.add(new HelperCustomApplyModelTask());
        tasks.add(new SetReadOnlyOnDataBindingTask());
        phase.setTasks(tasks);
        ArrayList skipLifecycleTasks = new ArrayList();
        skipLifecycleTasks.add(new SuffixIdFromContainerTask());
        phase.setSkipLifecycleTasks(skipLifecycleTasks);
        return phase;
    }

    protected ViewLifecyclePhase buildFinalizePhase() {
        FinalizeComponentPhase phase = new FinalizeComponentPhase();
        ArrayList tasks = new ArrayList();
        tasks.add(new InvokeFinalizerTask());
        tasks.add(new ComponentDefaultFinalizeTask());
        tasks.add(new AddViewTemplatesTask());
        tasks.add(new FinalizeViewTask());
        tasks.add(new RunComponentModifiersTask());
        tasks.add(new HelperCustomFinalizeTask());
        tasks.add(new RegisterPropertyEditorTask());
        tasks.add(new AddFocusAndJumpDataAttributesTask());
        phase.setTasks(tasks);
        phase.setSkipLifecycleTasks(new ArrayList());
        return phase;
    }

    protected ViewLifecyclePhase buildRenderPhase() {
        RenderComponentPhase phase = new RenderComponentPhase();
        ArrayList tasks = new ArrayList();
        tasks.add(new RenderComponentTask());
        phase.setTasks(tasks);
        phase.setSkipLifecycleTasks(new ArrayList());
        return phase;
    }
}

