/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.model;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.ActionField;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.util.GlobalVariables;

public class ApplyAuthAndPresentationLogicTask
extends ViewLifecycleTaskBase<Component> {
    public ApplyAuthAndPresentationLogicTask() {
        super(Component.class);
    }

    @Override
    protected void performLifecycleTask() {
        ViewModel model = (ViewModel)ViewLifecycle.getModel();
        Component component = (Component)this.getElementState().getElement();
        View view = ViewLifecycle.getView();
        ViewPresentationController presentationController = view.getPresentationController();
        ViewAuthorizer authorizer = view.getAuthorizer();
        if (GlobalVariables.getUserSession() == null) {
            return;
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        if (!component.isRender()) {
            return;
        }
        if (component instanceof View) {
            if (!Boolean.TRUE.equals(view.getReadOnly())) {
                if (model.isCanEditView() == null) {
                    boolean canEditView = authorizer.canEditView(view, model, user);
                    if (canEditView) {
                        canEditView = presentationController.canEditView(view, model);
                    }
                    view.setReadOnly(!canEditView);
                    model.setCanEditView(canEditView);
                } else {
                    view.setReadOnly(model.isCanEditView() == false);
                }
            }
        } else if (component instanceof Group) {
            Group group = (Group)component;
            if (!group.isHidden()) {
                boolean canViewGroup = authorizer.canViewGroup(view, model, group, group.getId(), user);
                if (canViewGroup) {
                    canViewGroup = presentationController.canViewGroup(view, model, group, group.getId());
                }
                group.setHidden(!canViewGroup);
                group.setRender(canViewGroup);
            }
            if (!Boolean.TRUE.equals(group.getReadOnly())) {
                boolean canEditGroup = authorizer.canEditGroup(view, model, group, group.getId(), user);
                if (canEditGroup) {
                    canEditGroup = presentationController.canEditGroup(view, model, group, group.getId());
                }
                group.setReadOnly(!canEditGroup);
            }
        } else if (component instanceof Field && !(component instanceof ActionField)) {
            Field field = (Field)component;
            String propertyName = null;
            if (field instanceof DataBinding) {
                propertyName = ((DataBinding)((Object)field)).getPropertyName();
            }
            if (!field.isHidden()) {
                boolean canViewField = authorizer.canViewField(view, model, field, propertyName, user);
                if (canViewField) {
                    canViewField = presentationController.canViewField(view, model, field, propertyName);
                }
                field.setHidden(!canViewField);
                field.setRender(canViewField);
            }
            if (!Boolean.TRUE.equals(field.getReadOnly())) {
                boolean canEditField = authorizer.canEditField(view, model, field, propertyName, user);
                if (canEditField) {
                    canEditField = presentationController.canEditField(view, model, field, propertyName);
                }
                field.setReadOnly(!canEditField);
            }
            if (field.getRequired() == null || !field.getRequired().booleanValue()) {
                presentationController.fieldIsRequired(view, model, field, propertyName);
            }
            if (field instanceof DataField) {
                DataField dataField = (DataField)field;
                boolean canUnmaskValue = authorizer.canUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                boolean canPartiallyUnmaskValue = authorizer.canPartialUnmaskField(view, model, dataField, dataField.getPropertyName(), user);
                boolean isMasked = this.isMaskField(dataField);
                boolean isPartialMask = this.isPartialMaskField(dataField);
                if (isMasked && !canUnmaskValue) {
                    dataField.setApplyMask(true);
                    dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getMaskFormatter());
                } else if (!(isMasked && canUnmaskValue || !isPartialMask || canPartiallyUnmaskValue)) {
                    dataField.setApplyMask(true);
                    dataField.setMaskFormatter(dataField.getDataFieldSecurity().getAttributeSecurity().getPartialMaskFormatter());
                }
            }
        } else if (component instanceof ActionField || component instanceof Action) {
            Action action = null;
            action = component instanceof ActionField ? ((ActionField)component).getAction() : (Action)component;
            boolean canTakeAction = authorizer.canPerformAction(view, model, action, action.getActionEvent(), action.getId(), user);
            if (canTakeAction) {
                canTakeAction = presentationController.canPerformAction(view, model, action, action.getActionEvent(), action.getId());
            }
            action.setRender(canTakeAction);
        } else if (component instanceof Widget) {
            Widget widget = (Widget)component;
            if (!widget.isHidden()) {
                boolean canViewWidget = authorizer.canViewWidget(view, model, widget, widget.getId(), user);
                if (canViewWidget) {
                    canViewWidget = presentationController.canViewWidget(view, model, widget, widget.getId());
                }
                widget.setHidden(!canViewWidget);
                widget.setRender(canViewWidget);
            }
            if (!Boolean.TRUE.equals(widget.getReadOnly())) {
                boolean canEditWidget = authorizer.canEditWidget(view, model, widget, widget.getId(), user);
                if (canEditWidget) {
                    canEditWidget = presentationController.canEditWidget(view, model, widget, widget.getId());
                }
                widget.setReadOnly(!canEditWidget);
            }
        }
    }

    private boolean isMaskField(DataField field) {
        if (field.getDataFieldSecurity() == null) {
            return false;
        }
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        return attributeSecurity != null && attributeSecurity.isMask();
    }

    private boolean isPartialMaskField(DataField field) {
        if (field.getDataFieldSecurity() == null) {
            return false;
        }
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        return attributeSecurity != null && attributeSecurity.isPartialMask();
    }
}

