/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.mock.DynaDataObject;
import org.kuali.rice.krad.uif.mock.DynaForm;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.FormView;

@BeanTag(name="mockView", parent="Uif-MockView")
public class MockView
extends FormView {
    private static final long serialVersionUID = 3075358370551614649L;
    private static final String DATA_BINDING_PATH = "data";
    private static final String BOOLEAN_DATA_BINDING_PATH = "booleanData";

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        DynaForm dynaForm = (DynaForm)model;
        List<DataBinding> bindingComponents = ViewLifecycleUtils.getElementsOfTypeDeep(this, DataBinding.class);
        for (DataBinding bindingComponent : bindingComponents) {
            this.adjustBindingPath(bindingComponent);
        }
        List<CollectionGroup> collectionGroups = ViewLifecycleUtils.getElementsOfTypeDeep(this, CollectionGroup.class);
        for (CollectionGroup collectionGroup : collectionGroups) {
            this.mockCollectionGroup(collectionGroup, dynaForm, null);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        List<DataField> dataFields = ViewLifecycleUtils.getElementsOfTypeDeep(this, DataField.class);
        for (DataField dataField : dataFields) {
            if (dataField instanceof InputField || dataField.getDefaultValue() != null) continue;
            this.createSampleData(dataField, model);
        }
        List<Action> actions = ViewLifecycleUtils.getElementsOfTypeDeep(this, Action.class);
        for (Action action : actions) {
            if (!StringUtils.isBlank((String)action.getMethodToCall())) continue;
            action.setMethodToCall("refresh");
        }
    }

    protected void adjustBindingPath(DataBinding bindingComponent) {
        boolean isBooleanDataType = false;
        if (bindingComponent instanceof InputField) {
            InputField inputField = (InputField)bindingComponent;
            if (inputField.getDataType() != null && inputField.getDataType().equals((Object)DataType.BOOLEAN)) {
                isBooleanDataType = true;
            } else if (inputField.getControl() != null && inputField.getControl() instanceof CheckboxControl) {
                isBooleanDataType = true;
            }
        }
        bindingComponent.getBindingInfo().setDefaults(this, bindingComponent.getPropertyName());
        if (isBooleanDataType) {
            bindingComponent.getBindingInfo().setBindByNamePrefix(BOOLEAN_DATA_BINDING_PATH);
        } else {
            bindingComponent.getBindingInfo().setBindByNamePrefix(DATA_BINDING_PATH);
        }
        bindingComponent.getBindingInfo().setBindToMap(true);
    }

    protected void mockCollectionGroup(CollectionGroup collectionGroup, DynaForm dynaForm, String bindingPrefix) {
        collectionGroup.setCollectionObjectClass(DynaDataObject.class);
        if (collectionGroup.getItems() != null) {
            for (Component component : collectionGroup.getItems()) {
                if (!(component instanceof DataBinding)) continue;
                this.adjustBindingPath((DataBinding)component);
            }
        }
        Object collectionPropertyName = collectionGroup.getPropertyName();
        if (StringUtils.isNotBlank((String)bindingPrefix)) {
            collectionPropertyName = bindingPrefix + "." + (String)collectionPropertyName;
        }
        collectionGroup.getAddLineBindingInfo().setBindingPath("newCollectionLines[" + (String)collectionPropertyName + "]");
        if (dynaForm.isInitialGetRequest()) {
            this.createSampleLineData(collectionGroup, dynaForm);
        }
        if (collectionGroup.getSubCollections() != null) {
            for (CollectionGroup subCollectionGroup : collectionGroup.getSubCollections()) {
                subCollectionGroup.getBindingInfo().setBindingName("data[" + subCollectionGroup.getPropertyName() + "]");
                this.mockCollectionGroup(subCollectionGroup, dynaForm, (String)collectionPropertyName);
            }
        }
    }

    protected void createSampleData(DataBinding bindingComponent, Object model) {
        String bindingPath = bindingComponent.getBindingInfo().getBindingPath();
        ObjectPropertyUtils.setPropertyValue(model, bindingPath, DATA_BINDING_PATH);
    }

    protected void createSampleLineData(CollectionGroup collectionGroup, Object model) {
        String bindingPath = collectionGroup.getBindingInfo().getBindingPath();
        ArrayList<DynaDataObject> collection = (ArrayList<DynaDataObject>)ObjectPropertyUtils.getPropertyValue(model, bindingPath);
        if (collection == null) {
            collection = new ArrayList<DynaDataObject>();
            ObjectPropertyUtils.setPropertyValue(model, bindingPath, collection);
        }
        collection.add(new DynaDataObject());
        collection.add(new DynaDataObject());
    }
}

