/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.web.format.FormatException;

public class UifDateTimeEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = -1315597474978280713L;
    private transient DateTimeService dateTimeService;

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue().equals("")) {
            return null;
        }
        DateTime value = (DateTime)this.getValue();
        return this.getDateTimeService().toDateTimeString((Date)new Timestamp(value.getMillis()));
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            java.sql.Date value = this.getDateTimeService().convertToSqlDate(text);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            if (calendar.get(1) < 1000 && this.verbatimYear(text).length() < 4) {
                throw new FormatException("illegal year format", "error.invalidDate", text);
            }
            this.setValue(new DateTime(value.getTime()));
        }
        catch (ParseException e) {
            throw new FormatException("parsing", "error.invalidDate", text, (Throwable)e);
        }
    }

    protected String verbatimYear(String date) {
        String result = "";
        int pos = date.lastIndexOf("/");
        if (pos >= 0) {
            result = date.substring(pos);
        }
        return result;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }
}

