/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.sql.Time;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.web.format.FormatException;

public class UifTimeEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 3087028215717940843L;
    private transient DateTimeService dateTimeService;

    @Override
    public String getAsText() {
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue() instanceof String && StringUtils.isBlank((String)((String)this.getValue()))) {
            return null;
        }
        return this.getDateTimeService().toTimeString((Time)this.getValue());
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.convertToObject(text));
    }

    protected Object convertToObject(String text) {
        if (StringUtils.isBlank((String)text)) {
            return null;
        }
        try {
            return this.getDateTimeService().convertToSqlTime(text);
        }
        catch (ParseException e) {
            throw new FormatException("parsing", "error.invalidTime", text, (Throwable)e);
        }
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)GlobalResourceLoader.getService((String)"dateTimeService");
        }
        return this.dateTimeService;
    }
}

