/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.exception.AuthenticationException;
import org.kuali.rice.krad.util.KRADUtils;

public class DummyLoginFilter
implements Filter {
    private String loginPath;
    private boolean showPassword = false;

    public void init(FilterConfig config) throws ServletException {
        this.loginPath = ConfigContext.getCurrentContextConfig().getProperty("loginPath");
        this.showPassword = Boolean.valueOf(ConfigContext.getCurrentContextConfig().getProperty("showPassword"));
        if (this.loginPath == null) {
            this.loginPath = "/kr-login/login?viewId=DummyLoginView";
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        final UserSession session = KRADUtils.getUserSessionFromRequest(request);
        if (session == null) {
            this.loginRequired((HttpServletRequest)request, response, chain);
            return;
        }
        request = new HttpServletRequestWrapper((HttpServletRequest)request){

            public String getRemoteUser() {
                return session.getPrincipalName();
            }
        };
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void loginRequired(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (StringUtils.isNotBlank((String)request.getParameter("__login_user"))) {
            this.performLoginAttempt(request, response);
        } else {
            if (StringUtils.equals((String)request.getPathInfo(), (String)"/listener")) {
                return;
            }
            if (StringUtils.equals((String)request.getPathInfo(), (String)"/login")) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendRedirect(this.getLoginRedirectUrl(request));
            }
        }
    }

    private void performLoginAttempt(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Principal principal;
        IdentityService auth = KimApiServiceLocator.getIdentityService();
        final String user = request.getParameter("__login_user");
        String password = request.getParameter("__login_pw");
        if (this.showPassword && StringUtils.isBlank((String)password)) {
            this.handleInvalidLogin((HttpServletRequest)request, response);
            return;
        }
        Principal principal2 = principal = this.showPassword ? auth.getPrincipalByPrincipalNameAndPassword(user, password) : auth.getPrincipalByPrincipalName(user);
        if (principal == null || !principal.isActive()) {
            this.handleInvalidLogin((HttpServletRequest)request, response);
            return;
        }
        UserSession userSession = new UserSession(user);
        if (userSession.getPerson() == null) {
            throw new AuthenticationException("Invalid User: " + user);
        }
        request.getSession().setAttribute("UserSession", (Object)userSession);
        request = new HttpServletRequestWrapper((HttpServletRequest)request){

            public String getRemoteUser() {
                return user;
            }
        };
        StringBuilder redirectUrl = new StringBuilder(ConfigContext.getCurrentContextConfig().getProperty("application.url"));
        redirectUrl.append(this.findTargetUrl((HttpServletRequest)request));
        response.sendRedirect(redirectUrl.toString());
    }

    private void handleInvalidLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringBuilder redirectUrl = new StringBuilder(this.getLoginRedirectUrl(request));
        redirectUrl.append("&login_message=Invalid Login");
        response.sendRedirect(redirectUrl.toString());
    }

    public void destroy() {
        this.loginPath = null;
    }

    private String getLoginRedirectUrl(HttpServletRequest request) throws IOException {
        String targetUrl = this.findTargetUrl(request);
        StringBuilder redirectUrl = new StringBuilder(ConfigContext.getCurrentContextConfig().getProperty("application.url"));
        redirectUrl.append(this.loginPath);
        redirectUrl.append("&returnLocation=");
        redirectUrl.append(URLEncoder.encode(targetUrl, "UTF-8"));
        return redirectUrl.toString();
    }

    private String findTargetUrl(HttpServletRequest request) {
        StringBuilder targetUrl = new StringBuilder();
        targetUrl.append(request.getServletPath());
        if (StringUtils.isNotBlank((String)request.getPathInfo())) {
            targetUrl.append(request.getPathInfo());
        }
        if (StringUtils.isNotBlank((String)request.getQueryString())) {
            targetUrl.append("?");
            for (String keyValuePair : request.getQueryString().split("&")) {
                if (!this.isValidProperty(keyValuePair).booleanValue()) continue;
                targetUrl.append("&").append(keyValuePair);
            }
        }
        return targetUrl.toString().replace("&&", "&").replace("?&", "?");
    }

    private Boolean isValidProperty(String keyValuePair) {
        int eq = keyValuePair.indexOf("=");
        if (eq < 0) {
            return Boolean.FALSE;
        }
        String key = keyValuePair.substring(0, eq);
        if (!(key.equals("__login_pw") || key.equals("__login_user") || key.equals("login_message"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

