/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.form.UifFormBase;

public class IncidentReportForm
extends UifFormBase {
    private static final long serialVersionUID = -6677581167041430694L;
    protected String errorMessage = "The system has encountered an error and is unable to complete your request at this time. Please provide more information regarding this error by completing this Incident Report.";
    protected Exception exception;
    protected String exceptionMessage;
    protected String exceptionStackTrace;
    protected String userInput;
    protected String incidentDocId;
    protected String incidentViewId;
    protected String controller;
    protected String userName;
    protected String userId;
    protected String userEmail;
    protected boolean devMode;

    public IncidentReportForm() {
        this.setViewTypeName(UifConstants.ViewType.INCIDENT);
    }

    public String createEmailMessage() {
        String format = "Document Id: %s%nView Id: %s%nHandler: %s%n%nUser Email: %s%nPerson User Identifier: %s%nPerson Name: %s%nUser Input: %s%n%nerrorMessage: %n%s";
        String message = String.format(format, this.incidentDocId == null ? "" : this.incidentDocId, this.incidentViewId == null ? "" : this.incidentViewId, this.controller == null ? "" : this.controller, this.userEmail == null ? "" : this.userEmail, this.userId == null ? "" : this.userId, this.userName == null ? "" : this.userName, this.userInput == null ? "" : this.userInput, this.exceptionStackTrace == null ? "" : this.exceptionStackTrace);
        return message;
    }

    public String createEmailSubject() {
        String app = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.id");
        String env = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("environment");
        String format = "%s:%s:%s:%s";
        String subject = String.format(format, app, env, this.incidentViewId == null ? "" : this.incidentViewId, this.truncateString(this.exceptionMessage, 180));
        return subject;
    }

    protected String truncateString(String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            str = str.substring(0, maxLength);
        }
        return str;
    }

    protected String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public void setExceptionStackTrace(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public void setIncidentDocId(String incidentDocId) {
        this.incidentDocId = incidentDocId;
    }

    public String getIncidentDocId() {
        return this.incidentDocId;
    }

    public void setIncidentViewId(String incidentViewId) {
        this.incidentViewId = incidentViewId;
    }

    public String getIncidentViewId() {
        return this.incidentViewId;
    }

    public void setException(Exception exception) {
        this.exception = exception;
        this.setExceptionStackTrace(this.getStackTrace(exception));
        this.setExceptionMessage(exception.getMessage());
    }

    public Exception getException() {
        return this.exception;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public String getController() {
        return this.controller;
    }

    public void setSessionId(String copiedSessionId) {
        this.sessionId = copiedSessionId;
    }
}

