/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.inquiry.Inquirable;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.view.InquiryView;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;

public class InquiryForm
extends UifFormBase {
    private static final long serialVersionUID = 4733144086378429410L;
    @RequestAccessible
    private String dataObjectClassName;
    private Object dataObject;
    private List<Note> boNotes;
    private boolean redirectedInquiry;

    public InquiryForm() {
        this.setViewTypeName(UifConstants.ViewType.INQUIRY);
        this.redirectedInquiry = false;
        this.boNotes = new ArrayList<Note>();
    }

    @Override
    public void postBind(HttpServletRequest request) {
        Inquirable inquirable;
        super.postBind(request);
        if (StringUtils.isBlank((String)this.getDataObjectClassName())) {
            this.setDataObjectClassName(((InquiryView)this.getView()).getDataObjectClassName().getName());
        }
        if ((inquirable = this.getInquirable()) != null) {
            Class<?> dataObjectClass;
            try {
                dataObjectClass = Class.forName(this.getDataObjectClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Object class " + this.getDataObjectClassName() + " not found", e);
            }
            inquirable.setDataObjectClass(dataObjectClass);
        }
    }

    public Inquirable getInquirable() {
        if (this.getViewHelperService() != null) {
            return (Inquirable)((Object)this.getViewHelperService());
        }
        return null;
    }

    public String getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(String dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public boolean isRedirectedInquiry() {
        return this.redirectedInquiry;
    }

    public void setRedirectedInquiry(boolean redirectedInquiry) {
        this.redirectedInquiry = redirectedInquiry;
    }

    public List<Note> getBoNotes() {
        return this.boNotes;
    }

    public void setBoNotes(List<Note> boNotes) {
        this.boNotes = boNotes;
    }
}

