/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.springframework.web.servlet.ModelAndView;

public class NavigationControllerServiceImpl
implements NavigationControllerService {
    private ModelAndViewService modelAndViewService;

    @Override
    public ModelAndView back(UifFormBase form) {
        boolean returnToFlowStart = false;
        String returnToStartActionParm = form.getActionParamaterValue("returnToStart");
        if (StringUtils.isNotBlank((String)returnToStartActionParm)) {
            returnToFlowStart = Boolean.parseBoolean(returnToStartActionParm);
        }
        return this.returnToHistory(form, true, false, returnToFlowStart);
    }

    @Override
    public ModelAndView returnToPrevious(UifFormBase form) {
        return this.returnToHistory(form, true, false, false);
    }

    @Override
    public ModelAndView returnToHub(UifFormBase form) {
        return this.returnToHistory(form, true, false, true);
    }

    @Override
    public ModelAndView returnToHistory(UifFormBase form, boolean returnToPrevious, boolean returnToApplicationHome, boolean returnToFlowStart) {
        Properties props = new Properties();
        props.put("methodToCall", "refresh");
        if (StringUtils.isNotBlank((String)form.getReturnFormKey())) {
            props.put("formKey", form.getReturnFormKey());
        }
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        String returnUrl = this.getReturnUrl(form, returnToPrevious, returnToApplicationHome, returnToFlowStart);
        return this.getModelAndViewService().performRedirect(form, returnUrl, props);
    }

    protected String getReturnUrl(UifFormBase form, boolean returnToPrevious, boolean returnToApplicationHome, boolean returnToFlowStart) {
        String returnUrl = null;
        if (returnToPrevious && StringUtils.isNotBlank((String)form.getReturnLocation())) {
            returnUrl = form.getReturnLocation();
        } else {
            HistoryFlow historyFlow = form.getHistoryManager().getMostRecentFlowByFormKey(form.getFlowKey(), form.getRequestedFormKey());
            if (historyFlow != null) {
                returnUrl = historyFlow.getFlowReturnPoint();
                if (returnToFlowStart && StringUtils.isNotBlank((String)historyFlow.getFlowStartPoint())) {
                    returnUrl = historyFlow.getFlowStartPoint();
                }
            }
        }
        if (StringUtils.isBlank((String)returnUrl) || returnToApplicationHome) {
            returnUrl = ConfigContext.getCurrentContextConfig().getProperty("application.url");
        }
        return returnUrl;
    }

    @Override
    public ModelAndView navigate(UifFormBase form) {
        form.setDirtyForm(false);
        String pageId = form.getActionParamaterValue("navigateToPageId");
        return this.getModelAndViewService().getModelAndView(form, pageId);
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }
}

