/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusContract;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryContract;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.county.County;
import org.kuali.rice.location.api.county.CountyContract;
import org.kuali.rice.location.api.county.CountyService;
import org.kuali.rice.location.api.postalcode.PostalCode;
import org.kuali.rice.location.api.postalcode.PostalCodeContract;
import org.kuali.rice.location.api.postalcode.PostalCodeService;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateContract;
import org.kuali.rice.location.api.state.StateService;
import org.kuali.rice.location.impl.campus.CampusBo;
import org.kuali.rice.location.impl.country.CountryBo;
import org.kuali.rice.location.impl.county.CountyBo;
import org.kuali.rice.location.impl.postalcode.PostalCodeBo;
import org.kuali.rice.location.impl.state.StateBo;

public class LocationRemoteModuleService
extends RemoteModuleServiceBase {
    private CampusService campusService;
    private StateService stateService;
    private CountryService countryService;
    private CountyService countyService;
    private PostalCodeService postalCodeService;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        if (CampusContract.class.isAssignableFrom(businessObjectClass)) {
            if (LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                Campus campus = this.getCampusService().getCampus((String)fieldValues.get("code"));
                return (T)((Object)CampusBo.from(campus));
            }
        } else if (StateContract.class.isAssignableFrom(businessObjectClass)) {
            if (LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode") && LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                State state = this.getStateService().getState((String)fieldValues.get("countryCode"), (String)fieldValues.get("code"));
                return (T)((Object)StateBo.from(state));
            }
        } else if (CountryContract.class.isAssignableFrom(businessObjectClass)) {
            if (LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"code")) {
                Country country = this.getCountryService().getCountry((String)fieldValues.get("code"));
                return (T)((Object)CountryBo.from(country));
            }
        } else if (CountyContract.class.isAssignableFrom(businessObjectClass)) {
            if (LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"code") && LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode") && LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"stateCode")) {
                County county = this.getCountyService().getCounty((String)fieldValues.get("countryCode"), (String)fieldValues.get("stateCode"), (String)fieldValues.get("code"));
                return (T)((Object)CountyBo.from(county));
            }
        } else if (PostalCodeContract.class.isAssignableFrom(businessObjectClass) && LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"code") && LocationRemoteModuleService.isNonBlankValueForKey(fieldValues, (String)"countryCode")) {
            PostalCode postalCode = this.getPostalCodeService().getPostalCode((String)fieldValues.get("countryCode"), (String)fieldValues.get("code"));
            return (T)((Object)PostalCodeBo.from(postalCode));
        }
        return null;
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
        Predicate predicate = PredicateUtils.convertObjectMapToPredicate(fieldValues);
        queryBuilder.setPredicates(new Predicate[]{predicate});
        return this.queryForEbos(businessObjectClass, queryBuilder.build());
    }

    public boolean isExternalizable(Class boClass) {
        if (CampusContract.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (StateContract.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (CountryContract.class.isAssignableFrom(boClass)) {
            return true;
        }
        if (CountyContract.class.isAssignableFrom(boClass)) {
            return true;
        }
        return PostalCodeContract.class.isAssignableFrom(boClass);
    }

    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.isExternalizable(boClass);
    }

    public List<String> listPrimaryKeyFieldNames(Class boClass) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("code");
        if (StateContract.class.isAssignableFrom(boClass) || PostalCodeContract.class.isAssignableFrom(boClass)) {
            primaryKeys.add("countryCode");
        }
        return primaryKeys;
    }

    public <T extends ExternalizableBusinessObject> List<T> queryForEbos(Class<T> businessObjectClass, QueryByCriteria query) {
        if (StateContract.class.isAssignableFrom(businessObjectClass)) {
            List states = this.getStateService().findStates(query).getResults();
            ArrayList<StateBo> stateEbos = new ArrayList<StateBo>(states.size());
            for (State state : states) {
                stateEbos.add(StateBo.from(state));
            }
            return stateEbos;
        }
        if (CampusContract.class.isAssignableFrom(businessObjectClass)) {
            List campuses = this.getCampusService().findCampuses(query).getResults();
            ArrayList<CampusBo> campusEbos = new ArrayList<CampusBo>(campuses.size());
            for (Campus campus : campuses) {
                campusEbos.add(CampusBo.from(campus));
            }
            return campusEbos;
        }
        if (CountryContract.class.isAssignableFrom(businessObjectClass)) {
            List countries = this.getCountryService().findCountries(query).getResults();
            ArrayList<CountryBo> countryEbos = new ArrayList<CountryBo>(countries.size());
            for (Country country : countries) {
                countryEbos.add(CountryBo.from(country));
            }
            return countryEbos;
        }
        if (CountyContract.class.isAssignableFrom(businessObjectClass)) {
            List counties = this.getCountyService().findCounties(query).getResults();
            ArrayList<CountyBo> countyEbos = new ArrayList<CountyBo>(counties.size());
            for (County county : counties) {
                countyEbos.add(CountyBo.from(county));
            }
            return countyEbos;
        }
        if (PostalCodeContract.class.isAssignableFrom(businessObjectClass)) {
            List postalCodes = this.getPostalCodeService().findPostalCodes(query).getResults();
            ArrayList<PostalCodeBo> postalCodeEbos = new ArrayList<PostalCodeBo>(postalCodes.size());
            for (PostalCode postalCode : postalCodes) {
                postalCodeEbos.add(PostalCodeBo.from(postalCode));
            }
            return postalCodeEbos;
        }
        return Collections.emptyList();
    }

    protected CampusService getCampusService() {
        if (this.campusService == null) {
            this.campusService = LocationApiServiceLocator.getCampusService();
        }
        return this.campusService;
    }

    protected StateService getStateService() {
        if (this.stateService == null) {
            this.stateService = LocationApiServiceLocator.getStateService();
        }
        return this.stateService;
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = LocationApiServiceLocator.getCountryService();
        }
        return this.countryService;
    }

    protected CountyService getCountyService() {
        if (this.countyService == null) {
            this.countyService = LocationApiServiceLocator.getCountyService();
        }
        return this.countyService;
    }

    protected PostalCodeService getPostalCodeService() {
        if (this.postalCodeService == null) {
            this.postalCodeService = LocationApiServiceLocator.getPostalCodeService();
        }
        return this.postalCodeService;
    }
}

