/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.List;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.HttpException;

public class BusClientFailureProxy
extends BaseTargetedInvocationHandler<Object> {
    private static final Logger LOG = LogManager.getLogger(BusClientFailureProxy.class);
    static final String SERVICE_REMOVAL_EXCEPTIONS_BEAN = "rice.ksb.serviceRemovalExceptions";
    static final String SERVICE_REMOVAL_RESPONSE_CODES_BEAN = "rice.ksb.serviceRemovalResponseCodes";
    private final Object failoverLock = new Object();
    private ServiceConfiguration serviceConfiguration;

    private BusClientFailureProxy(Object target, ServiceConfiguration serviceConfiguration) {
        super(target);
        this.serviceConfiguration = serviceConfiguration;
    }

    public static Object wrap(Object target, ServiceConfiguration serviceConfiguration) {
        return Proxy.newProxyInstance(ClassLoaderUtils.getDefaultClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)target), (InvocationHandler)((Object)new BusClientFailureProxy(target, serviceConfiguration)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object proxyObject, Method method, Object[] params) throws Throwable {
        HashSet<ServiceConfiguration> servicesTried = null;
        while (true) {
            try {
                return method.invoke(this.getTarget(), params);
            }
            catch (Throwable throwable) {
                if (BusClientFailureProxy.isServiceRemovalException(throwable)) {
                    Object object = this.failoverLock;
                    synchronized (object) {
                        LOG.error("Exception caught accessing remote service " + this.serviceConfiguration.getServiceName() + " at " + this.serviceConfiguration.getEndpointUrl(), throwable);
                        if (servicesTried == null) {
                            servicesTried = new HashSet<ServiceConfiguration>();
                            servicesTried.add(this.serviceConfiguration);
                        }
                        Object failoverService = null;
                        List endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(this.serviceConfiguration.getServiceName(), this.serviceConfiguration.getApplicationId());
                        for (Endpoint endpoint : endpoints) {
                            if (servicesTried.contains(endpoint.getServiceConfiguration())) continue;
                            failoverService = endpoint.getService();
                            if (Proxy.isProxyClass(failoverService.getClass()) && Proxy.getInvocationHandler(failoverService) instanceof BusClientFailureProxy) {
                                failoverService = ((BusClientFailureProxy)((Object)Proxy.getInvocationHandler(failoverService))).getTarget();
                            }
                            servicesTried.add(endpoint.getServiceConfiguration());
                            break;
                        }
                        if (failoverService == null) {
                            LOG.error("Didn't find replacement service throwing exception");
                            throw throwable;
                        }
                        LOG.info("Refetched replacement service for service " + this.serviceConfiguration.getServiceName() + " at " + this.serviceConfiguration.getEndpointUrl());
                        this.setTarget(failoverService);
                    }
                    continue;
                }
                throw throwable;
            }
            break;
        }
    }

    private static boolean isServiceRemovalException(Throwable throwable) {
        LOG.info("Checking for Service Removal Exception: " + throwable.getClass().getName());
        if (BusClientFailureProxy.getServiceRemovalExceptions().contains(throwable.getClass())) {
            LOG.info("Found a Service Removal Exception: " + throwable.getClass().getName());
            return true;
        }
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            if (BusClientFailureProxy.getServiceRemovalResponseCodes().contains(httpException.getResponseCode())) {
                LOG.info("Found a Service Removal Exception because of a " + httpException.getResponseCode() + " " + throwable.getClass().getName());
                return true;
            }
        } else if (throwable instanceof HTTPException) {
            HTTPException httpException = (HTTPException)throwable;
            if (BusClientFailureProxy.getServiceRemovalResponseCodes().contains(httpException.getResponseCode())) {
                LOG.info("Found a Service Removal Exception because of a " + httpException.getResponseCode() + " " + throwable.getClass().getName());
                return true;
            }
        }
        if (throwable.getCause() != null) {
            LOG.info("Unwrapping Throwable cause to check for service removal exception from: " + throwable.getClass().getName());
            return BusClientFailureProxy.isServiceRemovalException(throwable.getCause());
        }
        return false;
    }

    private static List<Class<?>> getServiceRemovalExceptions() {
        return ServiceRemovalExceptionsHolder.serviceRemovalExceptions;
    }

    private static List<Integer> getServiceRemovalResponseCodes() {
        return ServiceRemovalResponseCodesHolder.serviceRemovalResponseCodes;
    }

    private static class ServiceRemovalResponseCodesHolder {
        static final List<Integer> serviceRemovalResponseCodes = (List)GlobalResourceLoader.getService((String)"rice.ksb.serviceRemovalResponseCodes");

        private ServiceRemovalResponseCodesHolder() {
        }
    }

    private static class ServiceRemovalExceptionsHolder {
        static final List<Class<?>> serviceRemovalExceptions = (List)GlobalResourceLoader.getService((String)"rice.ksb.serviceRemovalExceptions");

        private ServiceRemovalExceptionsHolder() {
        }
    }
}

