/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class MessageFetcher
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(MessageFetcher.class);
    private Integer maxMessages;
    private Long routeQueueId;

    public MessageFetcher(Integer maxMessages) {
        this.maxMessages = maxMessages;
    }

    public MessageFetcher(Long routeQueueId) {
        this.routeQueueId = routeQueueId;
    }

    @Override
    public void run() {
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("message.persistence", false)) {
            try {
                this.requeueDocument();
                this.requeueMessages();
            }
            catch (Throwable t) {
                LOG.error("Failed to fetch messages.", t);
            }
        }
    }

    private void requeueMessages() {
        if (this.routeQueueId == null) {
            try {
                for (PersistedMessageBO message : this.getRouteQueueService().getNextDocuments(this.maxMessages)) {
                    message = this.markEnrouteAndSaveMessage(message);
                    this.executeMessage(message);
                }
            }
            catch (Throwable t) {
                LOG.error("Failed to fetch or process some messages during requeueMessages", t);
            }
        }
    }

    private void requeueDocument() {
        try {
            if (this.routeQueueId != null) {
                PersistedMessageBO message = this.getRouteQueueService().findByRouteQueueId(this.routeQueueId);
                message.setQueueStatus("R");
                message = this.getRouteQueueService().save(message);
                this.executeMessage(message);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to fetch or process some messages during requeueDocument", t);
        }
    }

    private void executeMessage(PersistedMessageBO message) {
        try {
            KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
        }
        catch (Throwable t) {
            LOG.error("Failed to place message " + message + " in thread pool for execution", t);
        }
    }

    private PersistedMessageBO markEnrouteAndSaveMessage(final PersistedMessageBO message) {
        try {
            return (PersistedMessageBO)KSBServiceLocator.getTransactionTemplate().execute((TransactionCallback)new TransactionCallback<PersistedMessageBO>(){

                public PersistedMessageBO doInTransaction(TransactionStatus status) {
                    message.setQueueStatus("R");
                    return MessageFetcher.this.getRouteQueueService().save(message);
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Caught error attempting to mark message " + message + " as R", t);
            return message;
        }
    }

    private MessageQueueService getRouteQueueService() {
        return KSBServiceLocator.getMessageQueueService();
    }
}

