/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.mo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.ModelBuilder;

public class ModelObjectUtils {
    public static <T> List<T> buildImmutableCopy(List<? extends ModelBuilder> builderList) {
        if (CollectionUtils.isEmpty(builderList)) {
            return Collections.emptyList();
        }
        ArrayList<Object> copy = new ArrayList<Object>();
        for (ModelBuilder modelBuilder : builderList) {
            Object built = modelBuilder.build();
            copy.add(built);
        }
        return Collections.unmodifiableList(copy);
    }

    public static <B> Set<B> buildImmutableCopy(Set<? extends ModelBuilder> toConvert) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return Collections.emptySet();
        }
        HashSet<Object> results = new HashSet<Object>(toConvert.size());
        for (ModelBuilder modelBuilder : toConvert) {
            results.add(modelBuilder.build());
        }
        return Collections.unmodifiableSet(results);
    }

    public static <T> T buildImmutable(ModelBuilder builder) {
        if (builder == null) {
            return null;
        }
        return (T)builder.build();
    }

    public static <T> List<T> createImmutableCopy(List<T> listToCopy) {
        if (CollectionUtils.isEmpty(listToCopy)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(listToCopy));
    }

    public static <T> Set<T> createImmutableCopy(Set<T> setToCopy) {
        if (CollectionUtils.isEmpty(setToCopy)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<T>(setToCopy));
    }

    public static <K, V> Map<K, V> createImmutableCopy(Map<K, V> mapToCopy) {
        if (mapToCopy == null || mapToCopy.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(mapToCopy));
    }

    public static <A, B> List<B> transform(Collection<? extends A> toConvert, Transformer<A, B> xform) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return new ArrayList();
        }
        ArrayList<B> results = new ArrayList<B>(toConvert.size());
        for (A elem : toConvert) {
            results.add(xform.transform(elem));
        }
        return results;
    }

    public static <A, B> Set<B> transformSet(Collection<? extends A> toConvert, Transformer<A, B> xform) {
        if (CollectionUtils.isEmpty(toConvert)) {
            return new HashSet();
        }
        HashSet<B> results = new HashSet<B>(toConvert.size());
        for (A elem : toConvert) {
            results.add(xform.transform(elem));
        }
        return results;
    }

    private ModelObjectUtils() {
        throw new UnsupportedOperationException("Do not call.");
    }

    public static interface Transformer<A, B> {
        public B transform(A var1);
    }
}

