/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.taglib.logic.ConditionalTagBase;
import org.apache.struts.util.MessageResources;

public abstract class CompareTagBase
extends ConditionalTagBase {
    protected static final int DOUBLE_COMPARE = 0;
    protected static final int LONG_COMPARE = 1;
    protected static final int STRING_COMPARE = 2;
    protected static MessageResources messages = MessageResources.getMessageResources((String)"org.apache.struts.taglib.logic.LocalStrings");
    public String value = null;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void release() {
        super.release();
        this.value = null;
    }

    protected abstract boolean condition() throws JspException;

    protected boolean condition(int desired1, int desired2) throws JspException {
        int type = -1;
        double doubleValue = 0.0;
        long longValue = 0L;
        if (type < 0 && this.value.length() > 0) {
            try {
                doubleValue = Double.parseDouble(this.value);
                type = 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (type < 0 && this.value.length() > 0) {
            try {
                longValue = Long.parseLong(this.value);
                type = 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (type < 0) {
            type = 2;
        }
        Object variable = null;
        if (this.cookie != null) {
            Cookie[] cookies = ((HttpServletRequest)this.pageContext.getRequest()).getCookies();
            if (cookies == null) {
                cookies = new Cookie[]{};
            }
            for (int i = 0; i < cookies.length; ++i) {
                if (!this.cookie.equals(cookies[i].getName())) continue;
                variable = cookies[i].getValue();
                break;
            }
        } else if (this.header != null) {
            variable = ((HttpServletRequest)this.pageContext.getRequest()).getHeader(this.header);
        } else if (this.name != null) {
            Object bean = TagUtils.getInstance().lookup(this.pageContext, this.name, this.scope);
            if (this.property != null) {
                if (bean == null) {
                    JspException e = new JspException(messages.getMessage("logic.bean", (Object)this.name));
                    TagUtils.getInstance().saveException(this.pageContext, e);
                    throw e;
                }
                try {
                    variable = PropertyUtils.getProperty((Object)bean, (String)this.property);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t == null) {
                        t = e;
                    }
                    TagUtils.getInstance().saveException(this.pageContext, t);
                    throw new JspException(messages.getMessage("logic.property", (Object)this.name, (Object)this.property, (Object)t.toString()));
                }
                catch (Throwable t) {
                    TagUtils.getInstance().saveException(this.pageContext, t);
                    throw new JspException(messages.getMessage("logic.property", (Object)this.name, (Object)this.property, (Object)t.toString()));
                }
            } else {
                variable = bean;
            }
        } else if (this.parameter != null) {
            variable = this.pageContext.getRequest().getParameter(this.parameter);
        } else {
            JspException e = new JspException(messages.getMessage("logic.selector"));
            TagUtils.getInstance().saveException(this.pageContext, e);
            throw e;
        }
        if (variable == null) {
            variable = "";
        }
        int result = 0;
        if (type == 0) {
            try {
                double doubleVariable = Double.parseDouble(variable.toString());
                if (doubleVariable < doubleValue) {
                    result = -1;
                } else if (doubleVariable > doubleValue) {
                    result = 1;
                }
            }
            catch (NumberFormatException e) {
                result = variable.toString().compareTo(this.value);
            }
        } else if (type == 1) {
            try {
                long longVariable = Long.parseLong(variable.toString());
                if (longVariable < longValue) {
                    result = -1;
                } else if (longVariable > longValue) {
                    result = 1;
                }
            }
            catch (NumberFormatException e) {
                result = variable.toString().compareTo(this.value);
            }
        } else {
            result = variable.toString().compareTo(this.value);
        }
        if (result < 0) {
            result = -1;
        } else if (result > 0) {
            result = 1;
        }
        return result == desired1 || result == desired2;
    }
}

