/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.single;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.transport.TransportService;

public class SingleNodeDiscovery
extends AbstractLifecycleComponent
implements Discovery {
    private static final Logger logger = LogManager.getLogger(SingleNodeDiscovery.class);
    private final ClusterName clusterName;
    protected final TransportService transportService;
    private final ClusterApplier clusterApplier;
    private volatile ClusterState clusterState;

    public SingleNodeDiscovery(Settings settings, TransportService transportService, MasterService masterService, ClusterApplier clusterApplier) {
        super(Objects.requireNonNull(settings));
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.transportService = Objects.requireNonNull(transportService);
        masterService.setClusterStateSupplier(() -> this.clusterState);
        this.clusterApplier = clusterApplier;
    }

    @Override
    public synchronized void publish(final ClusterChangedEvent event, final Discovery.AckListener ackListener) {
        this.clusterState = event.state();
        ackListener.onCommit(TimeValue.ZERO);
        final CountDownLatch latch = new CountDownLatch(1);
        ClusterApplier.ClusterApplyListener listener = new ClusterApplier.ClusterApplyListener(){

            @Override
            public void onSuccess(String source) {
                latch.countDown();
                ackListener.onNodeAck(SingleNodeDiscovery.this.transportService.getLocalNode(), null);
            }

            @Override
            public void onFailure(String source, Exception e) {
                latch.countDown();
                ackListener.onNodeAck(SingleNodeDiscovery.this.transportService.getLocalNode(), e);
                logger.warn(() -> new ParameterizedMessage("failed while applying cluster state locally [{}]", (Object)event.source()), (Throwable)e);
            }
        };
        this.clusterApplier.onNewClusterState("apply-locally-on-node[" + event.source() + "]", () -> this.clusterState, listener);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats(null, null);
    }

    @Override
    public synchronized void startInitialJoin() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("can't start initial join when not started");
        }
        this.clusterState = ClusterState.builder(this.clusterState).build();
        this.clusterApplier.onNewClusterState("single-node-start-initial-join", () -> this.clusterState, (source, e) -> {});
    }

    @Override
    protected synchronized void doStart() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        this.clusterState = this.createInitialState(localNode);
        this.clusterApplier.setInitialState(this.clusterState);
    }

    protected ClusterState createInitialState(DiscoveryNode localNode) {
        ClusterState.Builder builder = this.clusterApplier.newClusterStateBuilder();
        return builder.nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).masterNodeId(localNode.getId()).build()).blocks(ClusterBlocks.builder().addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)).build();
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() throws IOException {
    }
}

