/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public class RecoveryFilesInfoRequest
extends TransportRequest {
    private long recoveryId;
    private ShardId shardId;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    int totalTranslogOps;

    public RecoveryFilesInfoRequest() {
    }

    RecoveryFilesInfoRequest(long recoveryId, ShardId shardId, List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.totalTranslogOps = totalTranslogOps;
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.recoveryId = in.readLong();
        this.shardId = ShardId.readShardId(in);
        int size = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readString());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.totalTranslogOps = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String phase1FileName : this.phase1FileNames) {
            out.writeString(phase1FileName);
        }
        out.writeVInt(this.phase1FileSizes.size());
        for (Long phase1FileSize : this.phase1FileSizes) {
            out.writeVLong(phase1FileSize);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String phase1ExistingFileName : this.phase1ExistingFileNames) {
            out.writeString(phase1ExistingFileName);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        for (Long phase1ExistingFileSize : this.phase1ExistingFileSizes) {
            out.writeVLong(phase1ExistingFileSize);
        }
        out.writeVInt(this.totalTranslogOps);
    }
}

